/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.CrNodeVersion;
import org.lamsfoundation.lams.contentrepository.IValue;
import org.lamsfoundation.lams.contentrepository.ValueFormatException;

public class CrNodeVersionProperty
implements IValue,
Serializable {
    private Long id;
    private String name;
    private String value;
    private int type;
    private CrNodeVersion crNodeVersion;
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$CrNodeVersionProperty == null ? (class$org$lamsfoundation$lams$contentrepository$CrNodeVersionProperty = CrNodeVersionProperty.class$("org.lamsfoundation.lams.contentrepository.CrNodeVersionProperty")) : class$org$lamsfoundation$lams$contentrepository$CrNodeVersionProperty));
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$CrNodeVersionProperty;

    public CrNodeVersionProperty(String name, String value, int type, CrNodeVersion crNodeVersion) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.crNodeVersion = crNodeVersion;
    }

    public CrNodeVersionProperty() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public CrNodeVersion getCrNodeVersion() {
        return this.crNodeVersion;
    }

    public void setCrNodeVersion(CrNodeVersion crNodeVersion) {
        this.crNodeVersion = crNodeVersion;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("value", (Object)this.getValue()).append("type", this.getType()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CrNodeVersionProperty)) {
            return false;
        }
        CrNodeVersionProperty castOther = (CrNodeVersionProperty)other;
        return new EqualsBuilder().append((Object)this.getId(), (Object)castOther.getId()).append((Object)this.getName(), (Object)castOther.getName()).append((Object)this.getValue(), (Object)castOther.getValue()).append(this.getType(), castOther.getType()).append((Object)this.getCrNodeVersion(), (Object)castOther.getCrNodeVersion()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).append((Object)this.getName()).append((Object)this.getValue()).append(this.getType()).append((Object)this.getCrNodeVersion()).toHashCode();
    }

    public String getString() {
        return this.value;
    }

    public double getDouble() throws ValueFormatException {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException nfe) {
            throw new ValueFormatException("Unable to convert value " + this.value + " to double.");
        }
    }

    public Calendar getDate() throws ValueFormatException {
        SimpleDateFormat df = new SimpleDateFormat();
        Date date = null;
        try {
            date = df.parse(this.value);
        }
        catch (ParseException e) {
            this.log.debug((Object)("Parse exception occured converting " + this.value + " to date."), (Throwable)e);
        }
        if (date == null) {
            throw new ValueFormatException("Unable to convert value " + this.value + " to Calendar.");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public long getLong() throws ValueFormatException {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException nfe) {
            throw new ValueFormatException("Unable to convert value " + this.value + " to long.");
        }
    }

    public Boolean getBoolean() throws ValueFormatException {
        return Boolean.valueOf(this.value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

