/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.dao.hibernate;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.CrCredential;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.IWorkspace;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;
import org.lamsfoundation.lams.contentrepository.dao.ICredentialDAO;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class CredentialDAO
extends HibernateDaoSupport
implements ICredentialDAO {
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$dao$hibernate$CredentialDAO == null ? (class$org$lamsfoundation$lams$contentrepository$dao$hibernate$CredentialDAO = CredentialDAO.class$("org.lamsfoundation.lams.contentrepository.dao.hibernate.CredentialDAO")) : class$org$lamsfoundation$lams$contentrepository$dao$hibernate$CredentialDAO));
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$dao$hibernate$CredentialDAO;

    public boolean checkCredential(ICredentials credential, IWorkspace workspace) throws RepositoryRuntimeException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking credential " + credential + " for workspace " + workspace));
        }
        if (credential == null || workspace == null || workspace.getWorkspaceId() == null) {
            return false;
        }
        return this.checkCredentialInternal(credential, workspace);
    }

    public boolean checkCredential(ICredentials credential) throws RepositoryRuntimeException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking credential " + credential));
        }
        if (credential == null) {
            return false;
        }
        return this.checkCredentialInternal(credential, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCredentialInternal(ICredentials credential, IWorkspace workspace) throws RepositoryRuntimeException {
        boolean credentialMatched = false;
        Session hibernateSession = this.getSession();
        Connection conn = null;
        Statement ps = null;
        try {
            block11: {
                try {
                    int val;
                    conn = hibernateSession.connection();
                    StringBuffer buf = new StringBuffer(200);
                    buf.append("select count(*) num from lams_cr_credential c");
                    if (workspace != null) {
                        buf.append(", lams_cr_workspace_credential wc ");
                    }
                    buf.append(" where c.name = \"");
                    buf.append(credential.getName());
                    buf.append("\" and c.password = \"");
                    buf.append(credential.getPassword());
                    buf.append("\"");
                    if (workspace != null) {
                        buf.append(" and wc.credential_id = c.credential_id ");
                        buf.append(" and wc.workspace_id = ");
                        buf.append(workspace.getWorkspaceId());
                    }
                    ps = conn.prepareStatement(buf.toString());
                    ps.execute();
                    ResultSet rs = ps.getResultSet();
                    if (!rs.next() || (val = rs.getInt("num")) <= 0) break block11;
                    credentialMatched = true;
                    if (val > 1) {
                        this.log.warn((Object)("More than one credential found for workspace " + workspace.getWorkspaceId() + " credential name " + credential.getName()));
                    }
                }
                catch (HibernateException e) {
                    this.log.error((Object)"Hibernate exception occured during login. ", (Throwable)e);
                    throw new RepositoryRuntimeException("Unable to login due to internal error.", e);
                }
                catch (SQLException se) {
                    this.log.error((Object)"SQL exception occured during login. ", (Throwable)se);
                    throw new RepositoryRuntimeException("Unable to login due to internal error.", se);
                }
            }
            Object var11_12 = null;
            if (ps == null) return credentialMatched;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException se2) {
                this.log.error((Object)"SQL exception occured during login, while closing statement. ", (Throwable)se2);
                throw new RepositoryRuntimeException("Unable to login due to internal error.", se2);
            }
        }
        try {}
        catch (SQLException se2) {
            this.log.error((Object)"SQL exception occured during login, while closing statement. ", (Throwable)se2);
            throw new RepositoryRuntimeException("Unable to login due to internal error.", se2);
        }
        ps.close();
        return credentialMatched;
    }

    public void insert(Object object) {
        this.getHibernateTemplate().save(object);
    }

    public void update(Object object) {
        this.getHibernateTemplate().update(object);
    }

    public void delete(Object object) {
        this.getHibernateTemplate().delete(object);
    }

    public CrCredential findByName(String name) {
        this.log.debug((Object)("Getting credential for name " + name));
        String queryString = "from CrCredential as c where c.name = ?";
        List credentials = this.getHibernateTemplate().find(queryString, (Object)name);
        if (credentials.size() == 0) {
            this.log.debug((Object)"No credentials found");
            return null;
        }
        return (CrCredential)credentials.get(0);
    }

    public List findAll(Class objClass) {
        String query = "from obj in class " + objClass.getName();
        return this.getHibernateTemplate().find(query);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

