/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.ObjectExtractor;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.DesignDetailDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.themes.dao.ICSSThemeDAO;
import org.lamsfoundation.lams.themes.dto.CSSThemeBriefDTO;
import org.lamsfoundation.lams.themes.dto.CSSThemeDTO;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.WorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;

public class AuthoringService
implements IAuthoringService {
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$authoring$service$AuthoringService == null ? (class$org$lamsfoundation$lams$authoring$service$AuthoringService = AuthoringService.class$("org.lamsfoundation.lams.authoring.service.AuthoringService")) : class$org$lamsfoundation$lams$authoring$service$AuthoringService));
    protected LearningDesignDAO learningDesignDAO;
    protected LearningLibraryDAO learningLibraryDAO;
    protected ActivityDAO activityDAO;
    protected UserDAO userDAO;
    protected WorkspaceFolderDAO workspaceFolderDAO;
    protected TransitionDAO transitionDAO;
    protected ToolDAO toolDAO;
    protected LicenseDAO licenseDAO;
    protected GroupingDAO groupingDAO;
    protected GroupDAO groupDAO;
    protected ICSSThemeDAO themeDAO;
    private FlashMessage flashMessage;
    static /* synthetic */ Class class$org$lamsfoundation$lams$authoring$service$AuthoringService;

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setTransitionDAO(TransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setLearningLibraryDAO(LearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setWorkspaceFolderDAO(WorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public void setToolDAO(ToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setLicenseDAO(LicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public ICSSThemeDAO getThemeDAO() {
        return this.themeDAO;
    }

    public void setThemeDAO(ICSSThemeDAO themeDAO) {
        this.themeDAO = themeDAO;
    }

    public LearningDesign getLearningDesign(Long learningDesignID) {
        return this.learningDesignDAO.getLearningDesignById(learningDesignID);
    }

    public void saveLearningDesign(LearningDesign learningDesign) {
        this.learningDesignDAO.insert((Object)learningDesign);
    }

    public List getAllLearningDesigns() {
        return this.learningDesignDAO.getAllLearningDesigns();
    }

    public void updateLearningDesign(LearningDesign learningDesign) {
        this.learningDesignDAO.update((Object)learningDesign);
    }

    public List getAllLearningLibraries() {
        return this.learningLibraryDAO.getAllLearningLibraries();
    }

    public String getLearningDesignDetails(Long learningDesignID) throws IOException {
        Object wddxPacket = null;
        LearningDesign design = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        if (design == null) {
            this.flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"getLearningDesignDetails", (Long)learningDesignID);
        } else {
            LearningDesignDTO learningDesignDTO = design.getLearningDesignDTO();
            this.flashMessage = new FlashMessage("getLearningDesignDetails", (Object)learningDesignDTO);
        }
        return this.flashMessage.serializeMessage();
    }

    private boolean containsNulls(String packet) {
        return packet.indexOf("<null />") != -1;
    }

    public String copyLearningDesign(Long originalDesignID, Integer copyType, Integer userID, Integer workspaceFolderID) throws UserException, LearningDesignException, WorkspaceFolderException, IOException {
        LearningDesign originalDesign = this.learningDesignDAO.getLearningDesignById(originalDesignID);
        if (originalDesign == null) {
            throw new LearningDesignException("No Learning Design with learning_design_id of:" + originalDesignID + " exists");
        }
        User user = this.userDAO.getUserById(userID);
        if (user == null) {
            throw new UserException("No such User with a user_id of:" + userID + " exists");
        }
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
        if (workspaceFolder == null) {
            throw new WorkspaceFolderException("No such WorkspaceFolder with workspace_folder_id of:" + workspaceFolderID + " exists");
        }
        LearningDesign designCopy = this.copyLearningDesign(originalDesign, copyType, user, workspaceFolder);
        this.flashMessage = new FlashMessage("copyLearningDesign", (Object)designCopy.getLearningDesignId());
        return this.flashMessage.serializeMessage();
    }

    public LearningDesign copyLearningDesign(LearningDesign originalLearningDesign, Integer copyType, User user) {
        WorkspaceFolder runSequencesFolder = this.workspaceFolderDAO.getRunSequencesFolderForUser(user.getUserId());
        return this.copyLearningDesign(originalLearningDesign, copyType, user, runSequencesFolder);
    }

    public LearningDesign copyLearningDesign(LearningDesign originalLearningDesign, Integer copyType, User user, WorkspaceFolder workspaceFolder) {
        LearningDesign newLearningDesign = LearningDesign.createLearningDesignCopy((LearningDesign)originalLearningDesign, (Integer)copyType);
        newLearningDesign.setUser(user);
        newLearningDesign.setWorkspaceFolder(workspaceFolder);
        this.learningDesignDAO.insert((Object)newLearningDesign);
        this.updateDesignActivities(originalLearningDesign, newLearningDesign);
        this.calculateFirstActivity(originalLearningDesign, newLearningDesign);
        this.updateDesignTransitions(originalLearningDesign, newLearningDesign);
        return newLearningDesign;
    }

    private void calculateFirstActivity(LearningDesign oldDesign, LearningDesign newDesign) {
        Integer oldUIID = oldDesign.getFirstActivity().getActivityUIID();
        Activity firstActivity = this.activityDAO.getActivityByUIID(oldUIID, newDesign);
        newDesign.setFirstActivity(firstActivity);
        Integer learning_design_ui_id = new Integer(newDesign.getLearningDesignId().intValue());
        newDesign.setLearningDesignUIID(learning_design_ui_id);
    }

    private void updateDesignActivities(LearningDesign originalLearningDesign, LearningDesign newLearningDesign) {
        HashSet<Activity> newActivities = new HashSet<Activity>();
        TreeSet oldParentActivities = new TreeSet(new ActivityOrderComparator());
        oldParentActivities.addAll(originalLearningDesign.getParentActivities());
        Iterator iterator = oldParentActivities.iterator();
        while (iterator.hasNext()) {
            Object parentActivity = iterator.next();
            Activity newParentActivity = this.getActivityCopy(parentActivity);
            newParentActivity.setLearningDesign(newLearningDesign);
            this.activityDAO.insert((Object)newParentActivity);
            newActivities.add(newParentActivity);
            TreeSet oldChildActivities = new TreeSet(new ActivityOrderComparator());
            oldChildActivities.addAll(this.getChildActivities((Activity)parentActivity));
            Iterator childIterator = oldChildActivities.iterator();
            while (childIterator.hasNext()) {
                Activity childActivity = (Activity)childIterator.next();
                Activity newChildActivity = this.getActivityCopy(childActivity);
                newChildActivity.setParentActivity(newParentActivity);
                newChildActivity.setParentUIID(newParentActivity.getActivityUIID());
                newChildActivity.setLearningDesign(newLearningDesign);
                this.activityDAO.insert((Object)newChildActivity);
                newActivities.add(newChildActivity);
            }
        }
        newLearningDesign.setActivities(newActivities);
    }

    public void updateDesignTransitions(LearningDesign originalLearningDesign, LearningDesign newLearningDesign) {
        HashSet<Transition> newTransitions = new HashSet<Transition>();
        Set oldTransitions = originalLearningDesign.getTransitions();
        Iterator iterator = oldTransitions.iterator();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            Transition newTransition = Transition.createCopy((Transition)transition);
            Activity toActivity = null;
            Activity fromActivity = null;
            if (newTransition.getToUIID() != null) {
                toActivity = this.activityDAO.getActivityByUIID(newTransition.getToUIID(), newLearningDesign);
            }
            if (newTransition.getFromUIID() != null) {
                fromActivity = this.activityDAO.getActivityByUIID(newTransition.getFromUIID(), newLearningDesign);
            }
            newTransition.setToActivity(toActivity);
            newTransition.setFromActivity(fromActivity);
            newTransition.setLearningDesign(newLearningDesign);
            this.transitionDAO.insert((Object)newTransition);
            newTransitions.add(newTransition);
        }
        newLearningDesign.setTransitions(newTransitions);
    }

    private Activity getActivityCopy(Object activity) {
        if (activity instanceof GroupingActivity) {
            GroupingActivity newGroupingActivity = GroupingActivity.createCopy((GroupingActivity)((GroupingActivity)activity));
            this.createGroupingForGroupingActivity(newGroupingActivity, (GroupingActivity)activity);
            return newGroupingActivity;
        }
        if (activity instanceof ComplexActivity) {
            return this.createComplexActivityCopy(activity);
        }
        if (activity instanceof GateActivity) {
            return this.createGateActivityCopy(activity);
        }
        return ToolActivity.createCopy((ToolActivity)((ToolActivity)activity));
    }

    private void createGroupingForGroupingActivity(GroupingActivity groupingActivity, GroupingActivity oldActivity) {
        Grouping grouping = oldActivity.getCreateGrouping();
        if (grouping.getGroupingTypeId() == Grouping.CHOSEN_GROUPING_TYPE) {
            ChosenGrouping chosenGrouping = ChosenGrouping.createCopy((ChosenGrouping)((ChosenGrouping)grouping));
            this.groupingDAO.insert((Object)chosenGrouping);
            groupingActivity.setCreateGrouping((Grouping)chosenGrouping);
        } else {
            RandomGrouping randomGrouping = RandomGrouping.createCopy((RandomGrouping)((RandomGrouping)grouping));
            this.groupingDAO.insert((Object)randomGrouping);
            groupingActivity.setCreateGrouping((Grouping)randomGrouping);
        }
    }

    private Activity createComplexActivityCopy(Object activity) {
        if (activity instanceof OptionsActivity) {
            return OptionsActivity.createCopy((OptionsActivity)((OptionsActivity)activity));
        }
        if (activity instanceof ParallelActivity) {
            return ParallelActivity.createCopy((ParallelActivity)((ParallelActivity)activity));
        }
        return SequenceActivity.createCopy((SequenceActivity)((SequenceActivity)activity));
    }

    private Activity createGateActivityCopy(Object activity) {
        if (activity instanceof ScheduleGateActivity) {
            return ScheduleGateActivity.createCopy((ScheduleGateActivity)((ScheduleGateActivity)activity));
        }
        if (activity instanceof PermissionGateActivity) {
            return PermissionGateActivity.createCopy((PermissionGateActivity)((PermissionGateActivity)activity));
        }
        return SynchGateActivity.createCopy((SynchGateActivity)((SynchGateActivity)activity));
    }

    private HashSet getChildActivities(Activity parentActivity) {
        HashSet childActivities = new HashSet();
        List list = this.activityDAO.getActivitiesByParentActivityId(parentActivity.getActivityId());
        if (list != null) {
            childActivities.addAll(list);
        }
        return childActivities;
    }

    public String storeLearningDesignDetails(String wddxPacket) throws Exception {
        LearningDesignDTO learningDesignDTO = null;
        if (this.containsNulls(wddxPacket)) {
            this.flashMessage = new FlashMessage("storeLearningDesignDetails", (Object)"WDDXPacket contains null", 1);
            return this.flashMessage.serializeMessage();
        }
        Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
        ObjectExtractor extractor = new ObjectExtractor(this.userDAO, this.learningDesignDAO, this.activityDAO, this.workspaceFolderDAO, this.learningLibraryDAO, this.licenseDAO, this.groupingDAO, this.toolDAO, this.groupDAO, this.transitionDAO);
        learningDesignDTO = new LearningDesignDTO(table);
        if (learningDesignDTO != null) {
            LearningDesign design = extractor.extractLearningDesignObject(learningDesignDTO);
            this.learningDesignDAO.insert((Object)design);
            this.flashMessage = new FlashMessage("storeLearningDesignDetails", (Object)design.getLearningDesignId());
        } else {
            this.flashMessage = new FlashMessage("storeLearningDesignDetails", (Object)"Invalid Object in WDDX packet", 1);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getAllLearningDesignDetails() throws IOException {
        Iterator iterator = this.getAllLearningDesigns().iterator();
        ArrayList arrayList = this.createDesignDetailsPacket(iterator);
        this.flashMessage = new FlashMessage("getAllLearningDesignDetails", (Object)arrayList);
        return this.flashMessage.serializeMessage();
    }

    private ArrayList createDesignDetailsPacket(Iterator iterator) {
        ArrayList<DesignDetailDTO> arrayList = new ArrayList<DesignDetailDTO>();
        while (iterator.hasNext()) {
            LearningDesign learningDesign = (LearningDesign)iterator.next();
            DesignDetailDTO designDetailDTO = learningDesign.getDesignDetailDTO();
            arrayList.add(designDetailDTO);
        }
        return arrayList;
    }

    public String getLearningDesignsForUser(Long userID) throws IOException {
        List list = this.learningDesignDAO.getLearningDesignByUserId(userID);
        ArrayList arrayList = this.createDesignDetailsPacket(list.iterator());
        this.flashMessage = new FlashMessage("getLearningDesignsForUser", (Object)arrayList);
        return this.flashMessage.serializeMessage();
    }

    public String getAllLearningLibraryDetails() throws IOException {
        Iterator iterator = this.getAllLearningLibraries().iterator();
        ArrayList<LearningLibraryDTO> libraries = new ArrayList<LearningLibraryDTO>();
        while (iterator.hasNext()) {
            LearningLibrary learningLibrary = (LearningLibrary)iterator.next();
            libraries.add(learningLibrary.getLearningLibraryDTO());
        }
        this.flashMessage = new FlashMessage("getAllLearningLibraryDetails", libraries);
        return this.flashMessage.serializeMessage();
    }

    public String storeTheme(String wddxPacket) throws Exception {
        if (this.containsNulls(wddxPacket)) {
            this.flashMessage = new FlashMessage("storeTheme", (Object)"WDDXPacket contains null", 1);
            return this.flashMessage.serializeMessage();
        }
        Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
        CSSThemeDTO themeDTO = new CSSThemeDTO(table);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Converted Theme packet. Packet was \n" + wddxPacket + "\nDTO is\n" + themeDTO));
        }
        CSSThemeVisualElement dbTheme = null;
        CSSThemeVisualElement storedTheme = null;
        if (themeDTO.getId() != null) {
            dbTheme = this.themeDAO.getThemeById(themeDTO.getId());
        }
        storedTheme = dbTheme == null ? themeDTO.createCSSThemeVisualElement() : themeDTO.updateCSSTheme(dbTheme);
        this.themeDAO.saveOrUpdateTheme(storedTheme);
        this.flashMessage = new FlashMessage("storeTheme", (Object)storedTheme.getId());
        return this.flashMessage.serializeMessage();
    }

    public String getTheme(Long themeId) throws IOException {
        CSSThemeVisualElement theme = this.themeDAO.getThemeById(themeId);
        if (theme == null) {
            this.flashMessage = FlashMessage.getNoSuchTheme((String)"wddxPacket", (Long)themeId);
        } else {
            CSSThemeDTO dto = new CSSThemeDTO(theme);
            this.flashMessage = new FlashMessage("getTheme", (Object)dto);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getThemes() throws IOException {
        List themes = this.themeDAO.getAllThemes();
        ArrayList<CSSThemeBriefDTO> themeList = new ArrayList<CSSThemeBriefDTO>();
        Iterator iterator = themes.iterator();
        while (iterator.hasNext()) {
            CSSThemeBriefDTO dto = new CSSThemeBriefDTO((CSSThemeVisualElement)iterator.next());
            themeList.add(dto);
        }
        this.flashMessage = new FlashMessage("getThemes", themeList);
        return this.flashMessage.serializeMessage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

