/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.security.AuthenticationMethodConfigurer;
import org.lamsfoundation.lams.security.DatabaseAuthenticator;
import org.lamsfoundation.lams.security.LDAPAuthenticator;
import org.lamsfoundation.lams.security.SimpleGroup;
import org.lamsfoundation.lams.security.UsernamePasswordLoginModule;
import org.lamsfoundation.lams.security.WebAuthAuthenticator;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethodParameter;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.web.util.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UniversalLoginModule
extends UsernamePasswordLoginModule {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$security$UniversalLoginModule == null ? (class$org$lamsfoundation$lams$security$UniversalLoginModule = UniversalLoginModule.class$("org.lamsfoundation.lams.security.UniversalLoginModule")) : class$org$lamsfoundation$lams$security$UniversalLoginModule));
    private static final String USE_OBJECT_CREDENTIAL_OPT = "useObjectCredential";
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");
    protected String dsJndiName;
    protected String rolesQuery;
    protected String propertyFilePath;
    static /* synthetic */ Class class$org$lamsfoundation$lams$security$UniversalLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.propertyFilePath = (String)options.get("authenticationPropertyFile");
        AuthenticationMethodConfigurer.setConfigFilePath(this.propertyFilePath);
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid;
        block11: {
            isValid = false;
            if (inputPassword != null) {
                if (inputPassword.length() == 0) {
                    return false;
                }
                log.debug((Object)("===> validatePassword() called: " + inputPassword + " : " + expectedPassword));
                try {
                    Object authenticator;
                    String username = this.getUsername();
                    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
                    UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
                    User user = service.getUserByLogin(username);
                    log.debug((Object)("===> authenticating user: " + username));
                    if (user == null) {
                        return false;
                    }
                    AuthenticationMethod method = null;
                    try {
                        method = service.getAuthenticationMethodForUser(username);
                        AuthenticationMethodConfigurer.configure(method);
                        this.dsJndiName = method.getParameterByName("dsJndiName").getValue();
                        this.rolesQuery = method.getParameterByName("rolesQuery").getValue();
                    }
                    catch (Exception e) {
                        log.debug((Object)("===>Exception : " + e));
                        return false;
                    }
                    List parameters = method.getAuthenticationMethodParameters();
                    for (int i = 0; i < parameters.size(); ++i) {
                        AuthenticationMethodParameter mp = (AuthenticationMethodParameter)parameters.get(i);
                        log.debug((Object)("===>" + mp.getName() + " = " + mp.getValue()));
                    }
                    String type = method.getAuthenticationMethodType().getDescription();
                    log.debug((Object)("===> authentication type :" + type));
                    if ("LDAP".equals(type)) {
                        authenticator = new LDAPAuthenticator(method);
                        isValid = ((LDAPAuthenticator)authenticator).authenticate(username, inputPassword);
                        log.debug((Object)("===> LDAP :: user:" + username + ":" + inputPassword + " authenticated! "));
                        break block11;
                    }
                    if ("LAMS".equals(type)) {
                        authenticator = new DatabaseAuthenticator(method);
                        isValid = ((DatabaseAuthenticator)authenticator).authenticate(username, inputPassword);
                        log.debug((Object)("===> LAMS:: user:" + username + ":" + inputPassword + " authenticated! "));
                        break block11;
                    }
                    if ("WEB_AUTH".equals(type)) {
                        log.debug((Object)("===> WEBAUTH: " + username + " type: " + type));
                        authenticator = new WebAuthAuthenticator();
                        log.debug((Object)("===> webauth authenticator is:" + authenticator));
                        isValid = ((WebAuthAuthenticator)authenticator).authenticate(username, inputPassword);
                        log.debug((Object)("===> WEBAUTH :: user:" + username + ":" + inputPassword + " authenticated! "));
                        break block11;
                    }
                    log.debug((Object)"Unexpected authentication type!");
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.debug((Object)("===> exception: " + e));
                }
            }
        }
        return isValid;
    }

    /*
     * Loose catch block
     */
    protected Group[] getRoleSets() throws LoginException {
        HashMap<String, Group> setsMap;
        block39: {
            SQLException e222;
            ResultSet rs;
            Statement ps;
            Connection conn;
            block37: {
                block33: {
                    SQLException e222;
                    Group[] groupArray;
                    block34: {
                        Group[] roleSets;
                        String username = this.getUsername();
                        conn = null;
                        setsMap = new HashMap<String, Group>();
                        ps = null;
                        rs = null;
                        InitialContext ctx = new InitialContext();
                        DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                        log.debug((Object)("===> getRoleSets() called: " + this.dsJndiName + ":" + this.rolesQuery));
                        conn = ds.getConnection();
                        ps = conn.prepareStatement(this.rolesQuery);
                        try {
                            ps.setString(1, username);
                        }
                        catch (ArrayIndexOutOfBoundsException ignore) {
                            // empty catch block
                        }
                        rs = ps.executeQuery();
                        if (rs.next()) break block33;
                        if (this.getUnauthenticatedIdentity() == null) {
                            throw new FailedLoginException("No matching username found in Roles");
                        }
                        groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                        Object var13_15 = null;
                        if (rs == null) break block34;
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    return groupArray;
                }
                do {
                    Group group;
                    String name = rs.getString(1);
                    String groupName = rs.getString(2);
                    if (groupName == null || groupName.length() == 0) {
                        groupName = "Roles";
                    }
                    if ((group = (Group)setsMap.get(groupName)) == null) {
                        group = new SimpleGroup(groupName);
                        setsMap.put(groupName, group);
                    }
                    try {
                        Principal p = super.createIdentity(name);
                        log.info((Object)("Assign user to role " + name));
                        group.addMember(p);
                    }
                    catch (Exception e3) {
                        log.debug((Object)("Failed to create principal: " + name), (Throwable)e3);
                    }
                } while (rs.next());
                Object var13_16 = null;
                if (rs == null) break block37;
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
            break block39;
            {
                catch (NamingException ex) {
                    throw new LoginException(ex.toString(true));
                }
                catch (SQLException ex) {
                    ((UsernamePasswordLoginModule)this).log.error((Object)"SQL failure", (Throwable)ex);
                    throw new LoginException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                SQLException e222;
                Object var13_17 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

