/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WorkspaceAction
extends DispatchAction {
    public static String USE_JSP_OUTPUT = "jspoutput";

    public IWorkspaceManagementService getWorkspaceManagementService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IWorkspaceManagementService)webContext.getBean("workspaceManagementService");
    }

    private ActionForward outputPacket(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String wddxPacket, String parameterName) throws IOException {
        String useJSP = WebUtil.readStrParam((HttpServletRequest)request, (String)USE_JSP_OUTPUT, (boolean)true);
        if (useJSP != null && useJSP.length() >= 0) {
            request.getSession().setAttribute(parameterName, (Object)wddxPacket);
            return mapping.findForward("success");
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward createFolderForFlash(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer parentFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"parentFolderID"));
        String folderName = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.createFolderForFlash(parentFolderID, folderName, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getFolderContents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        Integer folderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
        Integer mode = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"mode"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.getFolderContents(userID, folderID, mode);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward deleteFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer folderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.deleteFolder(folderID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward deleteLearningDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long learningDesignID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"learningDesignID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.deleteLearningDesign(learningDesignID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward copyFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer folderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
        Integer targetFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"targetFolderID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.copyFolder(folderID, targetFolderID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward moveFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer currentFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"currentFolderID"));
        Integer targetFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"targetFolderID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.moveFolder(currentFolderID, targetFolderID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward createWorkspaceFolderContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        Integer contentTypeID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"contentType"));
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        String description = WebUtil.readStrParam((HttpServletRequest)request, (String)"description");
        Date createDateTime = new Date(WebUtil.readStrParam((HttpServletRequest)request, (String)"createDateTime"));
        Date lastModifiedDate = new Date(WebUtil.readStrParam((HttpServletRequest)request, (String)"lastModifiedDateTime"));
        Integer workspaceFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"workspaceFolderID"));
        String mimeType = WebUtil.readStrParam((HttpServletRequest)request, (String)"mimeType");
        String path = WebUtil.readStrParam((HttpServletRequest)request, (String)"path");
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.createWorkspaceFolderContent(contentTypeID, name, description, createDateTime, lastModifiedDate, workspaceFolderID, mimeType, path);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward updateWorkspaceFolderContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        Long folderContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"folderContentID"));
        String path = WebUtil.readStrParam((HttpServletRequest)request, (String)"path");
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.updateWorkspaceFolderContent(folderContentID, path);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward deleteWorkspaceFolderContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        Long folderContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"folderContentID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.deleteWorkspaceFolderContent(folderContentID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAccessibleWorkspaceFolders(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.getAccessibleWorkspaceFolders(userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward moveLearningDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Integer targetFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"targetFolderID"));
        Long learningDesignID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"learningDesignID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.moveLearningDesign(learningDesignID, targetFolderID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward renameWorkspaceFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Integer folderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.renameWorkspaceFolder(folderID, name, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward renameLearningDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Long learningDesignID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"learningDesignID"));
        String title = WebUtil.readStrParam((HttpServletRequest)request, (String)"title");
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.renameLearningDesign(learningDesignID, title, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getWorkspace(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.getWorkspace(userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward deleteContentWithVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long uuID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"uuID"));
        Long versionID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"versionID"));
        Long folderContentID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderContentID"));
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.deleteContentWithVersion(uuID, versionID, folderContentID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }
}

