/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XMember;
import xjavadoc.XMethod;

public class MethodTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$XDocletMessages;
    static /* synthetic */ Class class$xdoclet$tagshandler$MethodTagsHandler;

    public static String getMethodTypeFor(XMethod method) {
        return method.getReturnType().getType().getQualifiedName() + method.getReturnType().getDimensionAsString();
    }

    public static String getTransformedMethodTypeFor(XMethod method) {
        return method.getReturnType().getType().getTransformedQualifiedName() + method.getReturnType().getDimensionAsString();
    }

    public static String getMethodNameWithoutPrefixFor(XMethod currentMethod) {
        String propertyName = currentMethod.getPropertyName();
        if (Character.isLowerCase(propertyName.charAt(0))) {
            return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        }
        return propertyName;
    }

    public static String getPropertyNameFor(XMethod method) {
        return method.getPropertyName();
    }

    public static boolean isGetter(String str) {
        return str.startsWith("get") || str.startsWith("is");
    }

    public static boolean isSetter(String str) {
        return str.startsWith("set");
    }

    public static boolean isGetterMethod(XMethod method) {
        return method.isPropertyAccessor();
    }

    public static boolean isSetterMethod(XMethod method) {
        return method.isPropertyMutator();
    }

    public static boolean hasMethod(XClass clazz, String methodName, String[] parameters, boolean setCurrentMethod) throws XDocletException {
        return MethodTagsHandler.hasExecutableMember(clazz, methodName, parameters, setCurrentMethod, 1);
    }

    public String getterPrefix() throws XDocletException {
        if (MethodTagsHandler.getCurrentMethod().getName().startsWith("get")) {
            return "get";
        }
        if (MethodTagsHandler.getCurrentMethod().getName().startsWith("is")) {
            return "is";
        }
        if (MethodTagsHandler.getCurrentMethod().getName().startsWith("set")) {
            String[] params = new String[]{MethodTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName()};
            if (MethodTagsHandler.hasMethod(MethodTagsHandler.getCurrentClass(), "is" + this.methodNameWithoutPrefix(), params, false)) {
                return "is";
            }
            return "get";
        }
        return "";
    }

    public String getterMethod() throws XDocletException {
        return this.getterPrefix() + this.methodNameWithoutPrefix();
    }

    public String setterMethod() throws XDocletException {
        return "set" + this.methodNameWithoutPrefix();
    }

    public void setCurrentMethod(String template, Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        XMethod oldMethod = MethodTagsHandler.getCurrentMethod();
        if (MethodTagsHandler.hasMethod(MethodTagsHandler.getCurrentClass(), methodName, parameters, true)) {
            this.generate(template);
        }
        MethodTagsHandler.setCurrentMethod(oldMethod);
    }

    public String modifiers() throws XDocletException {
        return this.modifiers(1);
    }

    public String methodComment(Properties attributes) throws XDocletException {
        return this.memberComment(attributes, 1);
    }

    public void ifHasMethodComment(String template) throws XDocletException {
        Properties attributes = new Properties();
        attributes.setProperty("no-comment-signs", "true");
        String comment = this.methodComment(attributes);
        if (!comment.trim().equals("")) {
            this.generate(template);
        }
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        return this.exceptionList(attributes, 1);
    }

    public void ifIsAbstract(String template, Properties attributes) throws XDocletException {
        if (this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void ifIsNotAbstract(String template, Properties attributes) throws XDocletException {
        if (!this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void ifReturnsVoid(String template, Properties attributes) throws XDocletException {
        if (this.returnsVoid(attributes)) {
            this.generate(template);
        }
    }

    public void ifDoesntReturnVoid(String template, Properties attributes) throws XDocletException {
        if (!this.returnsVoid(attributes)) {
            this.generate(template);
        }
    }

    public void forAllClassMethods(String template, Properties attributes) throws XDocletException {
        String typeName = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        Collection classes = MethodTagsHandler.getAllClasses();
        TreeSet methods = new TreeSet();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            if (typeName != null && !TypeTagsHandler.isOfType(clazz, typeName, extent)) continue;
            List classMethods = clazz.getMethods();
            methods.addAll(classMethods);
        }
        Iterator methodIterator = methods.iterator();
        while (methodIterator.hasNext()) {
            XMethod current = (XMethod)methodIterator.next();
            MethodTagsHandler.setCurrentClass(current.getContainingClass());
            MethodTagsHandler.setCurrentMethod(current);
            this.generate(template);
        }
    }

    public void forAllMethods(String template, Properties attributes) throws XDocletException {
        this.forAllMembers(template, attributes, 1);
    }

    public void ifDoesntHaveMethodTag(String template, Properties attributes) throws XDocletException {
        if (!MethodTagsHandler.hasTag(attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasMethodTag(String template, Properties attributes) throws XDocletException {
        if (MethodTagsHandler.hasTag(attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreMethod(String template, Properties attributes) throws XDocletException {
        XMethod method = MethodTagsHandler.getCurrentMethod();
        this.generate(template);
        MethodTagsHandler.setCurrentMethod(method);
    }

    public void ifMethodTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (MethodTagsHandler.isTagValueEqual(attributes, 1)) {
            this.generate(template);
        }
    }

    public void ifMethodNameEquals(String template, Properties attributes) throws XDocletException {
        this.ifMethodNameEquals_Impl(template, attributes, true);
    }

    public void ifMethodNameNotEquals(String template, Properties attributes) throws XDocletException {
        this.ifMethodNameEquals_Impl(template, attributes, false);
    }

    public void ifMethodTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!MethodTagsHandler.isTagValueEqual(attributes, 1)) {
            this.generate(template);
        }
    }

    public String methodTagValue(Properties attributes) throws XDocletException {
        return MethodTagsHandler.getExpandedDelimitedTagValue(attributes, 1);
    }

    public void forAllMethodTags(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTags(template, attributes, 1, "ONLY_CALL_METHOD_NOT_NULL", new String[]{"forAllMethodTags"});
    }

    public void forAllMethodTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 1);
    }

    public String firstSentenceDescriptionOfCurrentMethod() throws XDocletException {
        return this.firstSentenceDescriptionOfCurrentMember((XMember)MethodTagsHandler.getCurrentMethod());
    }

    public String methodType(Properties attributes) throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor(MethodTagsHandler.getCurrentMethod());
    }

    public String transformedMethodType(Properties attributes) throws XDocletException {
        return MethodTagsHandler.getTransformedMethodTypeFor(MethodTagsHandler.getCurrentMethod());
    }

    public void ifIsOfType(String template, Properties attributes) throws XDocletException {
        if (this.ifIsOfTypeImpl(template, attributes)) {
            this.generate(template);
        }
    }

    public void ifIsNotOfType(String template, Properties attributes) throws XDocletException {
        if (!this.ifIsOfTypeImpl(template, attributes)) {
            this.generate(template);
        }
    }

    public boolean ifIsOfTypeImpl(String template, Properties attributes) throws XDocletException {
        return this.methodType(attributes).equals(attributes.getProperty("type"));
    }

    public String methodName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)attributes.get("value")) != null) {
            String m = MethodTagsHandler.getCurrentMethod().getName().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return MethodTagsHandler.getCurrentMethod() != null ? MethodTagsHandler.getCurrentMethod().getName() : "";
    }

    public String methodNameWithoutPrefix() throws XDocletException {
        return MethodTagsHandler.getMethodNameWithoutPrefixFor(MethodTagsHandler.getCurrentMethod());
    }

    public String currentMethodName() throws XDocletException {
        return MethodTagsHandler.getCurrentMethod().getName();
    }

    public String propertyName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor(MethodTagsHandler.getCurrentMethod());
    }

    public void ifHasMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, true);
    }

    public void ifDoesntHaveMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, false);
    }

    public void ifIsGetter(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name != null) {
            if (MethodTagsHandler.isGetter(method_name)) {
                this.generate(template);
            }
        } else if (MethodTagsHandler.isGetterMethod(MethodTagsHandler.getCurrentMethod())) {
            this.generate(template);
        }
    }

    public void ifIsSetter(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name != null) {
            if (MethodTagsHandler.isSetter(method_name)) {
                this.generate(template);
            }
        } else if (MethodTagsHandler.isSetterMethod(MethodTagsHandler.getCurrentMethod())) {
            this.generate(template);
        }
    }

    public void ifIsPublic(String template) throws XDocletException {
        if (MethodTagsHandler.getCurrentMethod().isPublic()) {
            this.generate(template);
        }
    }

    public void ifThrowsException(String template, Properties attributes) throws XDocletException {
        String checkExceptions = attributes.getProperty("exceptions");
        String memberName = null;
        List exceptions = null;
        XMethod executableMember = null;
        executableMember = MethodTagsHandler.getCurrentMethod();
        memberName = attributes.getProperty("method");
        if (executableMember == null && memberName == null) {
            exceptions = new ArrayList();
        }
        exceptions = memberName == null ? executableMember.getThrownExceptions() : ((executableMember = this.getXExecutableMemberForMemberName(memberName, true, 1)) != null ? executableMember.getThrownExceptions() : new ArrayList());
        String type = null;
        Iterator i = exceptions.iterator();
        while (i.hasNext()) {
            type = ((XClass)i.next()).getQualifiedName();
            if (checkExceptions == null || checkExceptions.indexOf(type) == -1) continue;
            this.generate(template);
        }
    }

    public void ifDoesntThrowException(String template, Properties attributes) throws XDocletException {
        String checkExceptions = attributes.getProperty("exceptions");
        String memberName = null;
        List exceptions = null;
        XMethod executableMember = null;
        executableMember = MethodTagsHandler.getCurrentMethod();
        memberName = attributes.getProperty("method");
        if (executableMember == null && memberName == null) {
            exceptions = new ArrayList();
        }
        exceptions = memberName == null ? executableMember.getThrownExceptions() : ((executableMember = this.getXExecutableMemberForMemberName(memberName, true, 1)) != null ? executableMember.getThrownExceptions() : new ArrayList());
        String type = null;
        Iterator i = exceptions.iterator();
        while (i.hasNext()) {
            type = ((XClass)i.next()).getQualifiedName();
            if (checkExceptions == null || checkExceptions.indexOf(type) != -1) continue;
            this.generate(template);
        }
    }

    private boolean isAbstract(Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("method");
        if (methodName == null) {
            return MethodTagsHandler.getCurrentMethod().isAbstract();
        }
        XMethod method = (XMethod)this.getXExecutableMemberForMemberName(methodName, true, 1);
        if (method == null) {
            throw new XDocletException(Translator.getString(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = MethodTagsHandler.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages, "METHOD_NOT_FOUND", new String[]{methodName}));
        }
        return method.isAbstract();
    }

    private boolean returnsVoid(Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("method");
        if (methodName == null) {
            return "void".equals(MethodTagsHandler.getMethodTypeFor(MethodTagsHandler.getCurrentMethod()));
        }
        XMethod method = (XMethod)this.getXExecutableMemberForMemberName(methodName, true, 1);
        if (method == null) {
            throw new XDocletException(Translator.getString(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = MethodTagsHandler.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages, "METHOD_NOT_FOUND", new String[]{methodName}));
        }
        return "void".equals(MethodTagsHandler.getMethodTypeFor(method));
    }

    private void ifMethodNameEquals_Impl(String template, Properties attributes, boolean condition) throws XDocletException {
        String method_name = attributes.getProperty("name");
        if (MethodTagsHandler.getCurrentMethod().getName().equals(method_name) == condition) {
            this.generate(template);
        }
    }

    private void ifHasMethod_Impl(String template, Properties attributes, boolean hasMethod) throws XDocletException {
        Log log = LogUtil.getLog(class$xdoclet$tagshandler$MethodTagsHandler == null ? (class$xdoclet$tagshandler$MethodTagsHandler = MethodTagsHandler.class$("xdoclet.tagshandler.MethodTagsHandler")) : class$xdoclet$tagshandler$MethodTagsHandler, "ifHasMethod_Impl");
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("methodName=" + methodName));
            log.debug((Object)("parametersStr=" + parametersStr));
            log.debug((Object)("delimiter=" + delimiter));
            log.debug((Object)("hasMethod=" + hasMethod));
            log.debug((Object)("getCurrentClass()=" + MethodTagsHandler.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parameters.length=" + parameters.length));
                if (parameters.length > 0) {
                    log.debug((Object)("parameters[0]=" + parameters[0]));
                }
            }
        }
        if (MethodTagsHandler.hasMethod(MethodTagsHandler.getCurrentClass(), methodName, parameters, false) == hasMethod) {
            log.debug((Object)"method found.");
            this.generate(template);
        } else {
            log.debug((Object)"method not found.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

