/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.data.course;

import blackboard.admin.data.FieldValidationUtility;
import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.IMembership;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbEnum;
import blackboard.base.BbList;
import blackboard.data.BbLink;
import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import blackboard.data.course.CourseMembership;
import blackboard.persist.Id;
import java.text.MessageFormat;

public abstract class Membership
extends CourseMembership
implements IMembership {
    protected Membership() {
        this._bbAttributes.removeBbAttribute("RowStatus");
        this._bbAttributes.setString("GroupBatchUid", null);
        this._bbAttributes.setString("PersonBatchUid", null);
        this._bbAttributes.setString("DataSourceBatchUid", null);
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)IAdminObject.RecStatus.DEFAULT);
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)IAdminObject.RowStatus.DEFAULT);
        this._bbAttributes.setInteger("idtype", 1);
        this._bbAttributes.setString("InheritedFromGroupBatchUid", null);
    }

    public IAdminObject.RowStatus getRowStatus() {
        return (IAdminObject.RowStatus)this._bbAttributes.getBbEnum("RowStatus");
    }

    public void setRowStatus(IAdminObject.RowStatus eRowStatus) {
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)eRowStatus);
    }

    public IAdminObject.RecStatus getRecStatus() {
        return (IAdminObject.RecStatus)this._bbAttributes.getBbEnum("RecStatus");
    }

    public void setRecStatus(IAdminObject.RecStatus eRecStatus) {
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)eRecStatus);
    }

    public String getDataSourceBatchUid() {
        return this._bbAttributes.getSafeString("DataSourceBatchUid");
    }

    public void setDataSourceBatchUid(String batchUid) {
        this._bbAttributes.setString("DataSourceBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("DataSourceId").setIsDirty(false);
    }

    public void setDataSourceId(Id iDataSourceId) {
        this._bbAttributes.setId("DataSourceId", iDataSourceId);
        this._bbAttributes.getBbAttribute("DataSourceBatchUid").setIsDirty(false);
    }

    public String getPersonBatchUid() {
        return this._bbAttributes.getSafeString("PersonBatchUid");
    }

    public void setPersonBatchUid(String batchUid) {
        this._bbAttributes.setString("PersonBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("UserId").setIsDirty(false);
    }

    public void setUserId(Id iUserId) {
        this._bbAttributes.setId("UserId", iUserId);
        this._bbAttributes.getBbAttribute("PersonBatchUid").setIsDirty(false);
    }

    protected String getGroupBatchUid() {
        return this._bbAttributes.getSafeString("GroupBatchUid");
    }

    protected Id getGroupId() {
        return super.getCourseId();
    }

    protected void setGroupBatchUid(String batchUid) {
        this._bbAttributes.setString("GroupBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("CourseId").setIsDirty(false);
    }

    protected void setGroupId(Id iGroupId) {
        this._bbAttributes.setId("CourseId", iGroupId);
        this._bbAttributes.getBbAttribute("GroupBatchUid").setIsDirty(false);
    }

    public String getInheritedFromGroupBatchUid() {
        return this._bbAttributes.getSafeString("InheritedFromGroupBatchUid");
    }

    protected Id getInheritedFromGroupId() {
        return super.getChildCourseId();
    }

    public void setInheritedFromGroupBatchUid(String batchUid) {
        this._bbAttributes.setString("InheritedFromGroupBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("ChildCourseId").setIsDirty(false);
    }

    protected void setInheritedFromGroupId(Id iGroupId) {
        this._bbAttributes.setId("ChildCourseId", iGroupId);
        this._bbAttributes.getBbAttribute("InheritedFromGroupBatchUid").setIsDirty(false);
    }

    public void setLinkUrl1(String val) {
        this.setLinkUrl(1, val);
    }

    public void setLinkDescription1(String val) {
        this.setLinkDescription(1, val);
    }

    public void setLinkName1(String val) {
        this.setLinkName(1, val);
    }

    public void setLinkName2(String val) {
        this.setLinkName(2, val);
    }

    public void setLinkUrl2(String val) {
        this.setLinkUrl(2, val);
    }

    public void setLinkDescription2(String val) {
        this.setLinkDescription(2, val);
    }

    public void setLinkName3(String val) {
        this.setLinkName(3, val);
    }

    public void setLinkUrl3(String val) {
        this.setLinkUrl(3, val);
    }

    public void setLinkDescription3(String val) {
        this.setLinkDescription(3, val);
    }

    public void validate() throws ValidationException {
        ValidationException ve = new ValidationException();
        String colName = "";
        Object[] args = new Object[]{colName};
        String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
        MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
        colName = "DataSourceBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getDataSourceBatchUid(), true, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "PersonBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getPersonBatchUid(), false, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "GroupBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getGroupBatchUid(), false, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (ve.getWarnings().size() > 0) {
            throw ve;
        }
    }

    public BbLink getBbLinkAtPos(int pos) {
        BbList bList = super.getFavoriteLinks();
        BbLink bLink = null;
        if (bList.size() >= --pos + 1) {
            bLink = (BbLink)bList.get(pos);
        }
        if (bLink == null) {
            bLink = new BbLink();
            bList.add(pos, (Object)bLink);
        }
        return bLink;
    }

    private void setLinkDescription(int pos, String val) {
        this.getBbLinkAtPos(pos).setDescription(val);
    }

    private void setLinkName(int pos, String val) {
        this.getBbLinkAtPos(pos).setName(val);
    }

    private void setLinkUrl(int pos, String val) {
        this.getBbLinkAtPos(pos).setUrl(val);
    }

    public String getChildBatchUid() {
        return this.getPersonBatchUid();
    }

    public IMembership.IdType getIdType() {
        return IMembership.IdType.fromInt(this._bbAttributes.getInteger("idtype"));
    }

    public String getParentBatchUid() {
        return this.getGroupBatchUid();
    }

    public void setChildBatchUid(String batchUid) {
        this.setPersonBatchUid(batchUid);
    }

    public void setIdType(int type) {
        this._bbAttributes.setInteger("idtype", type);
    }

    public void setParentBatchUid(String batchUid) {
        this.setGroupBatchUid(batchUid);
    }

    public void setChildBatchUidDirty(boolean dirty) {
        this._bbAttributes.getBbAttribute("PersonBatchUid").setIsDirty(dirty);
    }

    public void setParentBatchUidDirty(boolean dirty) {
        this._bbAttributes.getBbAttribute("GroupBatchUid").setIsDirty(dirty);
    }
}

