/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.integration;

import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.data.ValidationException;
import blackboard.data.user.User;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.user.UserDbLoader;
import blackboard.persist.user.UserDbPersister;
import blackboard.platform.BbServiceManager;
import blackboard.platform.integration.service.IntegrationEventListener;
import blackboard.platform.integration.service.UserLmsIntegrationDbLoader;
import blackboard.platform.integration.service.UserLmsIntegrationDbPersister;
import java.sql.Connection;
import java.util.List;

public class UserIntegrationEventListener
implements IntegrationEventListener {
    protected static final String RESET_PASSWORD = "4CB9C8A8048FD02294477FCB1A41191A";

    public void integrationDeleted(Id integrationId, Connection con) throws PersistenceException {
        BbServiceManager.getLogService().logDebug("Resetting the dataSource and password for users in integration " + integrationId.toExternalString());
        DataSource systemDataSource = DataSourceLoader.Default.getInstance().loadByBatchUid("SYSTEM");
        Id dataSourceId = systemDataSource.getId();
        UserLmsIntegrationDbPersister.Default.getInstance().resetUsersInOneIntegration(integrationId, dataSourceId, RESET_PASSWORD, con);
    }

    public void userDeIntegrated(Id userId, Id integrationId) throws PersistenceException {
        List integrationIds = UserLmsIntegrationDbLoader.Default.getInstance().getAllIntegrationIdsByUserId(userId);
        if (integrationIds == null || integrationIds.size() < 1) {
            User user = UserDbLoader.Default.getInstance().loadById(userId);
            user.setPassword(RESET_PASSWORD);
            try {
                UserDbPersister.Default.getInstance().persist(user);
            }
            catch (ValidationException e) {
                BbServiceManager.getLogService().logError("Unable to reset password for user " + user);
            }
        }
    }

    public void integrationCacheFlushed() {
    }
}

