/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.category.AdminCategory;
import blackboard.admin.data.category.CategoryXmlDef;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.persist.category.CourseCategoryXmlPersister;
import blackboard.admin.persist.category.OrganizationCategoryXmlPersister;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CategoryXmlPersisterImpl
extends AdminPersister
implements CategoryXmlDef,
CourseCategoryXmlPersister,
OrganizationCategoryXmlPersister {
    public Element persist(CourseCategory obj, Document doc) {
        return this.persist((AdminCategory)obj, doc);
    }

    public Element persist(OrganizationCategory obj, Document doc) {
        return this.persist((AdminCategory)obj, doc);
    }

    protected Element persist(AdminCategory obj, Document doc) {
        Element rootElement = doc.createElement("category");
        String type = String.valueOf(0);
        if (obj instanceof OrganizationCategory) {
            type = String.valueOf(1);
        }
        rootElement.setAttribute("type", type);
        this.persistSourceIdNode(obj, rootElement, doc);
        this.persistExtensionNode(obj, rootElement, doc);
        return rootElement;
    }

    protected void persistSourceIdNode(AdminCategory obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("sourcedid");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"source", (String)"Bb Platform");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"id", (String)obj.getBatchUid());
        rootElement.appendChild(childElement);
    }

    protected void persistExtensionNode(AdminCategory obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("extension");
        if (obj.getBbAttributes().getBbAttribute("RowStatus").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_row_status", (String)String.valueOf(ConversionUtility.rowStatusToInt(obj.getRowStatus())));
        }
        if (obj.getBbAttributes().getBbAttribute("FrontPageInd").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_frontpage_indicator", (String)ConversionUtility.booleanToYN(obj.getFrontPageInd()));
        }
        if (obj.getBbAttributes().getBbAttribute("IsAvailable").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_available_indicator", (String)ConversionUtility.booleanToYN(obj.getIsAvailable()));
        }
        if (obj.getBbAttributes().getBbAttribute("IsRestricted").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_restrict_indicator", (String)ConversionUtility.booleanToYN(obj.getIsRestricted()));
        }
        if (obj.getBbAttributes().getBbAttribute("ParentBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_parent_key", (String)obj.getParentBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("ReplacementBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_replacementkey", (String)obj.getReplacementBatchUid());
        }
        if (obj.getBbAttributes().getBbAttribute("Title").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_title", (String)obj.getTitle());
        }
        if (obj.getBbAttributes().getBbAttribute("Description").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_description", (String)obj.getDescription());
        }
        if (obj.getBbAttributes().getBbAttribute("DataSourceBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_datasource_key", (String)obj.getDataSourceBatchUid());
        }
        if (obj.getDataSourceId().isSet()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_data_source_id", (String)obj.getDataSourceId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("id").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_id", (String)obj.getId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("ParentId").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_parent_id", (String)obj.getParentId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("embed") != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_embedded_source", (String)obj.getBbAttributes().getSafeString("embed"));
        }
        rootElement.appendChild(childElement);
    }
}

