/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.persist.category.CourseCategoryPersister;
import blackboard.admin.persist.category.impl.CourseCategoryDbLoader;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryDeleteDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryInsertDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryPersisterDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;

public class CourseCategoryDbPersister
extends SnapshotDbPersister
implements CourseCategoryPersister {
    String[] CONSTRAINTS = new String[]{"GATEWAY_CATEGORIES_PK", "GATEWAY_CATEGORIES_AK1"};

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "gc");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "gc", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "gc");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((CourseCategory)obj);
        super.save(CourseCategoryPersisterDbMap.MAP, obj, strSessionId);
        this.resolveReplacementBatchUid((CourseCategory)obj);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(CourseCategoryPersisterDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return super.remove(CourseCategoryDeleteDbMap.MAP, objList);
    }

    public void save(CourseCategory objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.save(CourseCategoryPersisterDbMap.MAP, objToSave, strSessionId);
    }

    public void insert(CourseCategory objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(CourseCategoryInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void save(CourseCategory objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(CourseCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
    }

    public void update(CourseCategory objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(CourseCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
    }

    private void resolveReplacementBatchUid(CourseCategory objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    public void remove(CourseCategory objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(CourseCategoryDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    public void changeKey(CourseCategory objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        objToSave.setReplacementBatchUid(newKey);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(CourseCategoryPersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
        }
        catch (PersistenceException e) {
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    private void resolveBatchUid(CourseCategory objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        CourseCategoryDbLoader loader = (CourseCategoryDbLoader)this._pm.getLoader("CourseCategoryLoader");
        CourseCategory obj = new CourseCategory();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        CourseCategory CourseCategory2 = (CourseCategory)list.get(0);
        objInput.setBatchUid(CourseCategory2.getBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (CourseCategory obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

