/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.persist.category.CourseCategoryMembershipPersister;
import blackboard.admin.persist.category.impl.CourseCategoryMembershipDbLoader;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryMembershipDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryMembershipDeleteDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;

public class CourseCategoryMembershipDbPersister
extends SnapshotDbPersister
implements CourseCategoryMembershipPersister {
    String[] CONSTRAINTS = new String[]{"GATEWAY_COURSE_CATEGORIES_PK", "GATEWAY_COURSE_CATEGORIES_AK1"};

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "gcc");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "gcc", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "gcc");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, ValidationException, KeyNotFoundException {
        this.resolveBatchUid((CourseCategoryMembership)obj);
        super.save(CourseCategoryMembershipDbMap.MAP, obj, strSessionId);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(CourseCategoryMembershipDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return super.remove(CourseCategoryMembershipDeleteDbMap.MAP, objList);
    }

    public void save(CourseCategoryMembership objToSave, String strSessionId) throws PersistenceException, ValidationException, KeyNotFoundException {
        this.resolveBatchUid(objToSave);
        super.save(CourseCategoryMembershipDbMap.MAP, objToSave, strSessionId);
    }

    public void insert(CourseCategoryMembership objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(CourseCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void save(CourseCategoryMembership objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(CourseCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void update(CourseCategoryMembership objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(CourseCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void remove(CourseCategoryMembership objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(CourseCategoryMembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(CourseCategoryMembership objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("GroupBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("CategoryBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        CourseCategoryMembershipDbLoader loader = (CourseCategoryMembershipDbLoader)this._pm.getLoader("CourseCategoryMembershipLoader");
        CourseCategoryMembership obj = new CourseCategoryMembership();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        CourseCategoryMembership membership = (CourseCategoryMembership)list.get(0);
        objInput.setCourseSiteBatchUid(membership.getCourseSiteBatchUid());
        objInput.setCategoryBatchUid(membership.getCategoryBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (CourseCategoryMembership obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

