/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.persist.category.CourseCategoryPersister;
import blackboard.admin.persist.category.impl.soap.admincategory.ClientUtility;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.snapshot.persist.Results;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.soap.ServerResponse;
import blackboard.util.ObjectSerializer;

public class CourseCategoryRemotePersister
extends AdminPersister
implements CourseCategoryPersister {
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, "CourseCategoryPersister");
        ServerResponse response = this.executeSoapCall(req);
        return (String)response.getResults();
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, "CourseCategoryPersister", sessionId);
        this.executeSoapCall(req);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.closeSession(strSessionId, "CourseCategoryPersister");
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        try {
            this.save((CourseCategory)obj, strSessionId);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.save(objList, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        return this.resolveInternalId(objList, response, "admincategory.id.list");
    }

    public Results remove(BbList objList) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove(objList);
        ServerResponse response = this.executeSoapCall(req);
        return (Results)ObjectSerializer.deSerializeObject((String)((String)response.getResults()));
    }

    public void save(CourseCategory objToSave, String strSessionId) throws PersistenceException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        BbList bList = new BbList();
        bList.add((Object)objToSave);
        this.resolveInternalId(bList, response, "admincategory.id.list");
    }

    public void insert(CourseCategory objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.insert(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void save(CourseCategory objToSave) throws PersistenceException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave);
        ServerResponse response = this.executeSoapCall(req);
        this.resolveInternalId(objToSave, response);
    }

    public void update(CourseCategory objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.update(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void remove(CourseCategory objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove(objToRemove);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public void changeKey(CourseCategory objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        objToSave.setReplacementBatchUid(newKey);
        this.update(objToSave);
    }
}

