/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.persist.category.OrganizationCategoryMembershipPersister;
import blackboard.admin.persist.category.impl.OrganizationCategoryMembershipDbLoader;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryMembershipDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryMembershipDeleteDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;

public class OrganizationCategoryMembershipDbPersister
extends SnapshotDbPersister
implements OrganizationCategoryMembershipPersister {
    String[] CONSTRAINTS = new String[]{"COMMUNITY_COURSE_CATEGORIES_PK", "COMMUNITY_COURSE_CATEGORY_AK1"};

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "ccc");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "ccc", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "ccc");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((OrganizationCategoryMembership)obj);
        super.save(OrganizationCategoryMembershipDbMap.MAP, obj, strSessionId);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(OrganizationCategoryMembershipDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return super.remove(OrganizationCategoryMembershipDeleteDbMap.MAP, objList);
    }

    public void save(OrganizationCategoryMembership objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(OrganizationCategoryMembershipDbMap.MAP, objToSave, strSessionId);
    }

    public void save(OrganizationCategoryMembership objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(OrganizationCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void insert(OrganizationCategoryMembership objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(OrganizationCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void update(OrganizationCategoryMembership objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(OrganizationCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void remove(OrganizationCategoryMembership objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(OrganizationCategoryMembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(OrganizationCategoryMembership objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("GroupBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("CategoryBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        OrganizationCategoryMembershipDbLoader loader = (OrganizationCategoryMembershipDbLoader)this._pm.getLoader("OrganizationCategoryMembershipLoader");
        OrganizationCategoryMembership obj = new OrganizationCategoryMembership();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        OrganizationCategoryMembership OrganizationCategoryMembership2 = (OrganizationCategoryMembership)list.get(0);
        objInput.setOrganizationBatchUid(OrganizationCategoryMembership2.getOrganizationBatchUid());
        objInput.setCategoryBatchUid(OrganizationCategoryMembership2.getCategoryBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (OrganizationCategoryMembership obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

