/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl.soap.admincategory;

import blackboard.admin.data.category.AdminCategory;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.persist.category.CourseCategoryLoader;
import blackboard.admin.persist.category.CourseCategoryPersister;
import blackboard.admin.persist.category.OrganizationCategoryLoader;
import blackboard.admin.persist.category.OrganizationCategoryPersister;
import blackboard.admin.persist.category.impl.soap.admincategory.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.platform.BbServiceManager;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "admincategory.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        Object pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            for (OrganizationCategory tmp : list) {
                p.insert(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        } else {
            CourseCategoryPersister p = (CourseCategoryPersister)ServerUtility.getPersister("CourseCategoryPersister");
            for (CourseCategory tmp : list) {
                p.insert(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        Object pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            for (OrganizationCategory tmp : list) {
                p.update(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        } else {
            CourseCategoryPersister p = (CourseCategoryPersister)ServerUtility.getPersister("CourseCategoryPersister");
            for (CourseCategory tmp : list) {
                p.update(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        Object pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            for (OrganizationCategory tmp : list) {
                p.save(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        } else {
            CourseCategoryPersister p = (CourseCategoryPersister)ServerUtility.getPersister("CourseCategoryPersister");
            for (CourseCategory tmp : list) {
                p.save(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        Persister p;
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        BbList list = ServerUtility.unMarshallObjects(props, obj);
        Object pObj = list.get(0);
        Results results = null;
        if (pObj instanceof OrganizationCategory) {
            p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            results = p.save(list, session);
        } else {
            p = (CourseCategoryPersister)ServerUtility.getPersister("CourseCategoryPersister");
            results = p.save(list, session);
        }
        Iterator iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            AdminCategory tmp = (AdminCategory)iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        Object pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            p.remove((OrganizationCategory)pObj);
        } else {
            CourseCategoryPersister p = (CourseCategoryPersister)ServerUtility.getPersister("CourseCategoryPersister");
            p.remove((CourseCategory)pObj);
        }
    }

    public static String removeList(String obj) throws PersistenceException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        Object pObj = list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryPersister p = (OrganizationCategoryPersister)ServerUtility.getPersister("OrganizationCategoryPersister");
            return ObjectSerializer.serializeObject((Object)p.remove(list));
        }
        CourseCategoryPersister p = (CourseCategoryPersister)ServerUtility.getPersister("CourseCategoryPersister");
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid, String persisterType) throws PersistenceException {
        SnapshotPersister p = (SnapshotPersister)ServerUtility.getPersister(persisterType);
        return p.createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String persisterType, String sessionId) throws PersistenceException {
        SnapshotPersister p = (SnapshotPersister)ServerUtility.getPersister(persisterType);
        p.createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId, String persisterType) throws PersistenceException {
        SnapshotPersister p = (SnapshotPersister)ServerUtility.getPersister(persisterType);
        p.closeSession(strSessionId);
    }

    public static String load(String batchUid, String loaderType) throws PersistenceException, KeyNotFoundException {
        AdminCategory obj = null;
        if (loaderType.equals("OrganizationCategoryLoader")) {
            OrganizationCategoryLoader oLoader = (OrganizationCategoryLoader)ServerUtility.getLoader(loaderType);
            obj = oLoader.load(batchUid);
        } else {
            CourseCategoryLoader cLoader = (CourseCategoryLoader)ServerUtility.getLoader(loaderType);
            obj = cLoader.load(batchUid);
        }
        return ClientUtility.convertToString(obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        BbList list = ServerUtility.unMarshallObjects(template);
        if (list.isEmpty()) {
            return "";
        }
        AdminCategory pObj = (AdminCategory)list.get(0);
        if (pObj instanceof OrganizationCategory) {
            OrganizationCategoryLoader oLoader = (OrganizationCategoryLoader)ServerUtility.getLoader("OrganizationCategoryLoader");
            list = oLoader.load((OrganizationCategory)pObj);
        } else {
            CourseCategoryLoader cLoader = (CourseCategoryLoader)ServerUtility.getLoader("CourseCategoryLoader");
            list = cLoader.load((CourseCategory)pObj);
        }
        return ClientUtility.convertToString(list);
    }

    private static Persister getPersister(String type) throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister(type);
    }

    private static Loader getLoader(String type) throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader(type);
    }

    public static BbList unMarshallObjects(String src) throws PersistenceException {
        return ServerUtility.unMarshallObjects(null, src);
    }

    public static BbList unMarshallObjects(Properties props, String src) throws PersistenceException {
        try {
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

