/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl.soap.categorymembership;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.persist.category.CourseCategoryMembershipLoader;
import blackboard.admin.persist.category.CourseCategoryMembershipPersister;
import blackboard.admin.persist.category.OrganizationCategoryMembershipLoader;
import blackboard.admin.persist.category.OrganizationCategoryMembershipPersister;
import blackboard.admin.persist.category.impl.soap.categorymembership.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.platform.BbServiceManager;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "categorymembership.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            for (OrganizationCategoryMembership tmp : list) {
                p.insert(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            for (CourseCategoryMembership tmp : list) {
                p.insert(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            for (OrganizationCategoryMembership tmp : list) {
                p.update(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            for (CourseCategoryMembership tmp : list) {
                p.update(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        BbObject pObj = (BbObject)list.get(0);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            for (OrganizationCategoryMembership tmp : list) {
                p.save(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            for (CourseCategoryMembership tmp : list) {
                p.save(tmp);
                aList.add(tmp.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        Persister p;
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        BbList list = ServerUtility.unMarshallObjects(props, obj);
        BbObject pObj = (BbObject)list.get(0);
        Results results = null;
        if (pObj instanceof OrganizationCategoryMembership) {
            p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            results = p.save(list, session);
        } else {
            p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            results = p.save(list, session);
        }
        Iterator iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            BbObject tmp = (BbObject)iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return;
        }
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            p.remove((OrganizationCategoryMembership)pObj);
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            p.remove((CourseCategoryMembership)pObj);
        }
    }

    public static String removeList(String obj) throws PersistenceException, ValidationException {
        BbList list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return null;
        }
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            return ObjectSerializer.serializeObject((Object)p.remove(list));
        }
        CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid, String persisterType) throws PersistenceException {
        SnapshotPersister p = (SnapshotPersister)ServerUtility.getPersister(persisterType);
        return p.createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String persisterType, String sessionId) throws PersistenceException {
        SnapshotPersister p = (SnapshotPersister)ServerUtility.getPersister(persisterType);
        p.createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId, String persisterType) throws PersistenceException {
        SnapshotPersister p = (SnapshotPersister)ServerUtility.getPersister(persisterType);
        p.closeSession(strSessionId);
    }

    public static String load(String crsBatchUid, String categoryBatchUid, String loaderType) throws PersistenceException, KeyNotFoundException {
        IAdminObject obj = null;
        if (loaderType.equals("OrganizationCategoryMembershipLoader")) {
            OrganizationCategoryMembershipLoader l = (OrganizationCategoryMembershipLoader)ServerUtility.getLoader(loaderType);
            obj = l.load(crsBatchUid, categoryBatchUid);
        } else {
            CourseCategoryMembershipLoader l = (CourseCategoryMembershipLoader)ServerUtility.getLoader(loaderType);
            obj = l.load(crsBatchUid, categoryBatchUid);
        }
        return ClientUtility.convertToString((BbObject)obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        BbList list = ServerUtility.unMarshallObjects(template);
        if (list.isEmpty()) {
            return "";
        }
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipLoader oLoader = (OrganizationCategoryMembershipLoader)ServerUtility.getLoader("OrganizationCategoryMembershipLoader");
            list = oLoader.load((OrganizationCategoryMembership)pObj);
        } else {
            CourseCategoryMembershipLoader cLoader = (CourseCategoryMembershipLoader)ServerUtility.getLoader("CourseCategoryMembershipLoader");
            list = cLoader.load((CourseCategoryMembership)pObj);
        }
        return ClientUtility.convertToString(list);
    }

    private static Persister getPersister(String persisterType) throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister(persisterType);
    }

    private static Loader getLoader(String loaderType) throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader(loaderType);
    }

    public static BbList unMarshallObjects(String src) throws PersistenceException {
        return ServerUtility.unMarshallObjects(null, src);
    }

    public static BbList unMarshallObjects(Properties props, String src) throws PersistenceException {
        try {
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

