/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course;

import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.base.BbEnum;
import blackboard.data.navigation.CourseToc;
import blackboard.persist.Id;
import blackboard.platform.BbServiceManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloneConfig
implements Serializable {
    private Integer _tranCount = new Integer(300);
    private ArrayList<String> _areaList = new ArrayList();
    private ArrayList<String> _tocIdList = new ArrayList();
    private Boolean _bReconcile;
    private String _strDataSourceId = null;
    private Boolean _bSuppressEvents;
    transient Map<String, CourseToc> _tocAreaMap = new HashMap<String, CourseToc>();
    transient CloneCallback _callback;
    transient ArrayList _originalTargetCourseTocList;
    static final long serialVersionUID = -6076185390264962900L;

    public CloneConfig() {
        this._bReconcile = Boolean.FALSE;
        this._bSuppressEvents = Boolean.FALSE;
        this._originalTargetCourseTocList = new ArrayList();
    }

    public Boolean getReconcileFlag() {
        return this._bReconcile;
    }

    public void setReconcileFlag(Boolean reconcile) {
        if (reconcile == null) {
            reconcile = Boolean.TRUE;
        }
        this._bReconcile = reconcile;
    }

    public Id getMembershipDataSourceId() {
        Id val = null;
        try {
            if (this._strDataSourceId != null) {
                val = BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, this._strDataSourceId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public void setMembershipDataSourceId(Id dataSourceId) {
        this._strDataSourceId = dataSourceId.toExternalString();
    }

    public List getCourseTocIdList() {
        return this._tocIdList;
    }

    public CourseToc getRegisteredCourseToc(Id id) {
        if (this._tocAreaMap == null) {
            return null;
        }
        return this._tocAreaMap.get(id.toExternalString());
    }

    public void includeArea(CourseToc area) {
        if (this.isAreaIncluded(area)) {
            return;
        }
        this._tocAreaMap.put(area.getId().toExternalString(), area);
        this.includeArea(area.getId());
    }

    public void includeArea(Id areaId) {
        if (!this.isAreaIncluded(areaId)) {
            this._tocIdList.add(areaId.toExternalString());
            this.includeArea(Area.COURSE_TOC);
        }
    }

    public void excludeArea(CourseToc area) {
        this._tocAreaMap.remove(area.getId());
        this.excludeArea(area.getId());
    }

    public void excludeArea(Id areaId) {
        this._tocIdList.remove(areaId.toExternalString());
        if (this._tocAreaMap.containsKey(areaId.toExternalString())) {
            this._tocAreaMap.remove(areaId.toExternalString());
        }
        if (this._tocIdList.isEmpty()) {
            this.excludeArea(Area.COURSE_TOC);
        }
    }

    public boolean isAreaIncluded(CourseToc area) {
        return this.isAreaIncluded(area.getId());
    }

    public boolean isAreaIncluded(Id area) {
        return this._tocIdList.contains(area.toExternalString());
    }

    public void includeArea(Area area) {
        if (area != Area.ALL) {
            if (!this.isAreaIncluded(area)) {
                if (area == Area.GRADES) {
                    this.includeArea(Area.MEMBERSHIP);
                } else if (area == Area.CHAT_ARCHIVE) {
                    this.includeArea(Area.CHAT_SESSION);
                } else if (area == Area.MEMBERSHIP_EXACT) {
                    this.includeArea(Area.MEMBERSHIP);
                }
                this._areaList.add(area.toExternalString());
            }
            return;
        }
        Area[] set = Area.getValues();
        for (int cnt = 0; cnt < set.length; ++cnt) {
            if (set[cnt] == Area.ALL) {
                this._areaList.add(Area.ALL.toExternalString());
                continue;
            }
            this.includeArea(set[cnt]);
        }
    }

    public void excludeArea(Area area) {
        if (area == Area.ALL) {
            this._areaList.clear();
            this._tocIdList.clear();
            this._tocAreaMap.clear();
            return;
        }
        if (area == Area.COURSE_TOC) {
            this._areaList.remove(area.toExternalString());
            this._tocIdList.clear();
            this._tocAreaMap.clear();
            return;
        }
        if (area == Area.MEMBERSHIP) {
            if (this.isAreaIncluded(Area.GRADES)) {
                this.excludeArea(Area.GRADES);
            }
        } else if (area == Area.CHAT_SESSION && this.isAreaIncluded(Area.CHAT_ARCHIVE)) {
            this.excludeArea(Area.CHAT_ARCHIVE);
        }
        this._areaList.remove(area.toExternalString());
    }

    public boolean isAreaIncluded(Area area) {
        return this._areaList.contains(area.toExternalString());
    }

    public void setCallback(CloneCallback callback) {
        this._callback = callback;
    }

    public CloneCallback getCallback() {
        return this._callback;
    }

    public void setOriginalTargetCourseTocList(ArrayList originalTargetCourseTocList) {
        this._originalTargetCourseTocList = originalTargetCourseTocList;
    }

    public ArrayList getOriginalTargetCourseTocList() {
        return this._originalTargetCourseTocList;
    }

    public int getMaximumTransactionCount() {
        return this._tranCount;
    }

    public void setMaximumTransactionCount(int tranCount) {
        this._tranCount = new Integer(tranCount);
    }

    public boolean getSuppressEvents() {
        return this._bSuppressEvents;
    }

    public void setSuppressEvents(boolean val) {
        this._bSuppressEvents = new Boolean(val);
    }

    public static class Area
    extends BbEnum {
        public static final Area ASSESSMENT = new Area("ASSESSMENT");
        public static final Area CATEGORY_MEMBERSHIP = new Area("CATEGORY_MEMBERSHIP");
        public static final Area ANNOUNCEMENT = new Area("ANNOUNCEMENT");
        public static final Area GLOSSARY = new Area("GLOSSARY");
        public static final Area CALENDAR = new Area("CALENDAR");
        public static final Area TASK = new Area("TASKS");
        public static final Area SETTING = new Area("SETTING");
        public static final Area CONTENT = new Area("CONTENT");
        public static final Area COURSE_TOC = new Area("COURSE_TOC");
        public static final Area CHAT_ARCHIVE = new Area("CHATARCHIVE");
        public static final Area CHAT_SESSION = new Area("CHATSESSION");
        public static final Area DROP_BOX = new Area("DROPBOX");
        public static final Area COURSE_STATISTICS = new Area("COURSESTATISTICS");
        public static final Area STAFF_INFORMATION = new Area("STAFFINFORMATION");
        public static final Area EARLY_WARNING_SYSTEM = new Area("EARLY_WARNING_SYSTEM");
        public static final Area DISCUSSION_BOARD = new Area("DISCUSSIONBOARD");
        public static final Area DISCUSSION_BOARD_ARCHIVE = new Area("DISCUSSIONBOARDARCHIVE");
        public static final Area GROUP = new Area("GROUP");
        public static final Area GRADEBOOK = new Area("GRADEBOOK");
        public static final Area GRADES = new Area("GRADES");
        public static final Area MEMBERSHIP = new Area("MEMBERSHIP");
        public static final Area MEMBERSHIP_EXACT = new Area("MEMBERSHIP_EXACT");
        public static final Area COURSE_CARTRIDGE = new Area("COURSE_CARTRIDGE");
        public static final Area DISCUSSION_CARTRIDGE = new Area("DISCUSSION_CARTRIDGE");
        public static final Area ASSESSEMENT_CARTRIDGE = new Area("ASSESSEMENT_CARTRIDGE");
        public static final Area AVAILABILITY_RULE = new Area("AVAILABILITY_RULE");
        public static final Area ALL = new Area("ALL");
        public static final Area DEFAULT = (Area)Area.defineDefault((BbEnum)ALL);
        static final long serialVersionUID = 1L;

        protected Area(String enumFieldName) {
            super(enumFieldName);
        }

        public static Area[] getValues() {
            return (Area[])BbEnum.getValues(Area.class);
        }

        public static Area fromExternalString(String externalString) throws IllegalArgumentException {
            return (Area)BbEnum.fromExternalString((String)externalString, Area.class);
        }
    }
}

