/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.persist.course.AdminCourseCourseLoader;
import blackboard.admin.persist.course.impl.mapping.AdminCourseCourseLoaderDbMap;
import blackboard.admin.persist.impl.AdminNewBaseDbLoader;
import blackboard.admin.persist.impl.AdminSelectQuery;
import blackboard.base.BbList;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.SelectQuery;

public class AdminCourseCourseDbLoader
extends AdminNewBaseDbLoader
implements AdminCourseCourseLoader {
    public AdminCourseCourse load(String parentCrsBatchUid, String childCrsBatchUid) throws KeyNotFoundException, PersistenceException {
        CourseDbLoader courseLoader = CourseDbLoader.Default.getInstance();
        Id parentId = courseLoader.loadByBatchUid(parentCrsBatchUid).getId();
        Id childId = courseLoader.loadByBatchUid(childCrsBatchUid).getId();
        AdminSelectQuery query = new AdminSelectQuery(AdminCourseCourseLoaderDbMap.MAP, "course_course");
        query.addWhere("ParentCourseId", parentId);
        query.addWhere("ChildCourseId", childId);
        return (AdminCourseCourse)super.loadObject((SelectQuery)query, null);
    }

    public AdminCourseCourse loadById(Id id) throws KeyNotFoundException, PersistenceException {
        AdminSelectQuery query = new AdminSelectQuery(AdminCourseCourseLoaderDbMap.MAP, "course_course");
        query.addWhere("id", id);
        AdminCourseCourse adminCC = (AdminCourseCourse)super.loadObject((SelectQuery)query, null);
        CourseDbLoader courseLoader = CourseDbLoader.Default.getInstance();
        String parentBatchUid = courseLoader.loadById(adminCC.getParentCourseId()).getBatchUid();
        String childBatchUid = courseLoader.loadById(adminCC.getChildCourseId()).getBatchUid();
        adminCC.setParentGroupBatchUid(parentBatchUid);
        adminCC.setChildGroupBatchUid(childBatchUid);
        return adminCC;
    }

    public BbList load(AdminCourseCourse template) throws PersistenceException {
        super.checkApiLicensing();
        if (template.getId() != null && template.getId().isSet()) {
            BbList list = new BbList();
            list.add((Object)this.loadById(template.getId()));
            return list;
        }
        if (template.getParentGroupBatchUid() != null && template.getChildGroupBatchUid() != null) {
            BbList list = new BbList();
            list.add((Object)this.load(template.getParentGroupBatchUid(), template.getChildGroupBatchUid()));
            return list;
        }
        if (template.getParentGroupBatchUid() != null) {
            CourseDbLoader courseLoader = CourseDbLoader.Default.getInstance();
            Id parentId = courseLoader.loadByBatchUid(template.getParentGroupBatchUid()).getId();
            AdminSelectQuery query = new AdminSelectQuery(AdminCourseCourseLoaderDbMap.MAP, "course_course");
            query.addWhere("ParentCourseId", parentId);
            return (BbList)super.loadList((SelectQuery)query, null);
        }
        if (template.getChildGroupBatchUid() != null) {
            CourseDbLoader courseLoader = CourseDbLoader.Default.getInstance();
            Id childId = courseLoader.loadByBatchUid(template.getChildGroupBatchUid()).getId();
            AdminSelectQuery query = new AdminSelectQuery(AdminCourseCourseLoaderDbMap.MAP, "course_course");
            query.addWhere("ChildCourseId", childId);
            return (BbList)super.loadList((SelectQuery)query, null);
        }
        return null;
    }
}

