/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.impl.CourseSiteDbLoader;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.mapping.AdminCourseDeleteDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCourseInsertDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCoursePersisterDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ImmutableException;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Query;
import blackboard.platform.BbServiceManager;
import blackboard.platform.RuntimeBbServiceException;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.platform.filesystem.FileSystemService;
import blackboard.util.ExceptionUtil;
import blackboard.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;

public class CourseSiteDbPersister
extends SnapshotDbPersister
implements CourseSitePersister {
    String[] CONSTRAINTS = new String[]{"COURSE_MAIN_PK", "COURSE_MAIN_AK1", "COURSE_MAIN_AK2", "COURSE_MAIN_AK3"};
    String[] IMMUTABLE = new String[]{"immutable"};

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            try {
                super.init(pm, appVersion);
            }
            catch (RuntimeBbServiceException exc) {
                if (!this._lMgr.isLicensed("integration.apis")) break block2;
                throw exc;
            }
        }
    }

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        super.checkApiLicensing();
        return super._createSession(dataSourceBatchUid, "course");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super.checkApiLicensing();
        super._createSession(dataSourceBatchUid, "course", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        super.closeSession(strSessionId, "course");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid((CourseSite)obj);
        try {
            super.save(AdminCoursePersisterDbMap.MAP, obj, strSessionId);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Course id cannot be modified.");
            }
            throw pe;
        }
        this.resolveReplacementBatchUid((CourseSite)obj);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(AdminCoursePersisterDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        super.checkApiLicensing();
        try {
            CourseSiteDbPersister.archiveCourseContent(objList);
        }
        catch (Exception exc) {
            BbServiceManager.getLogService().logWarning("Failure occurred during course archival", (Throwable)exc);
        }
        return super.remove(AdminCourseDeleteDbMap.MAP, objList);
    }

    public void save(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Course id cannot be modified.");
            }
            this._checkForConstraintViolation(pe, this.CONSTRAINTS);
        }
    }

    public void save(CourseSite objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.checkApiLicensing();
        try {
            super.save(AdminCoursePersisterDbMap.MAP, objToSave, strSessionId);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Course id cannot be modified.");
            }
            throw pe;
        }
    }

    public void insert(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(AdminCourseInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void update(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
        }
        catch (PersistenceException e) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)e, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Course id cannot be modified.");
            }
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    private void resolveReplacementBatchUid(CourseSite objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    public void remove(CourseSite objToRemove) throws KeyNotFoundException, PersistenceException {
        super.checkApiLicensing();
        try {
            CourseSiteDbPersister.archiveCourseContent(objToRemove);
        }
        catch (Exception exc) {
            BbServiceManager.getLogService().logWarning("Failure occurred during course archival", (Throwable)exc);
        }
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(AdminCourseDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    public void changeKey(CourseSite objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        super.checkApiLicensing();
        objToSave.setReplacementBatchUid(newKey);
        try {
            this.update(objToSave);
        }
        catch (PersistenceException e) {
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    public void clone(final String srcCrsBatchUid, final String tgtCrsBatchUid, final CloneConfig cfg) throws PersistenceException, KeyNotFoundException, ValidationException, ConstraintViolationException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    AdminCourseCloneOperator op = new AdminCourseCloneOperator(CourseSiteDbPersister.this._pm, CourseSiteDbPersister.this._appVersion);
                    CourseDbLoader loader = (CourseDbLoader)CourseSiteDbPersister.this._pm.getLoader("CourseDbLoader");
                    Course src = loader.loadByBatchUid(srcCrsBatchUid);
                    Course tgt = loader.loadByBatchUid(tgtCrsBatchUid);
                    op.clone(cfg, src, tgt);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable rootCause = pae.getCause();
            if (rootCause instanceof PersistenceException) {
                if (rootCause instanceof KeyNotFoundException) {
                    throw (KeyNotFoundException)rootCause;
                }
                super._checkForConstraintViolation(new PersistenceException(rootCause), this.CONSTRAINTS);
            }
            if (rootCause instanceof ValidationException) {
                throw (ValidationException)rootCause;
            }
            if (rootCause instanceof ConstraintViolationException) {
                throw (ConstraintViolationException)rootCause;
            }
            throw new PersistenceException(rootCause);
        }
    }

    protected static void archiveCourseContent(BbList list) throws PersistenceException, IOException, FileSystemException {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            CourseSiteDbPersister.archiveCourseContent((AdminCourse)iter.next());
        }
    }

    protected static void archiveCourseContent(AdminCourse crs) throws PersistenceException, IOException, FileSystemException {
        CourseSiteLoader cLoader;
        CourseSite vCrs;
        FileSystemService service = (FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class);
        File fCourseDir = service.getCourseDirectory((vCrs = (cLoader = (CourseSiteLoader)BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("CourseSiteLoader")).load(crs.getBatchUid())).getCourseId());
        if (fCourseDir.exists()) {
            File archiveDir = new File(service.getRecycleDirectory(), "1");
            File absArchiveDir = new File(archiveDir, vCrs.getCourseId());
            if (absArchiveDir.exists()) {
                FileUtil.delete((File)absArchiveDir);
            }
            FileUtil.moveDirectory((File)fCourseDir, (File)absArchiveDir);
        }
    }

    private void resolveBatchUid(CourseSite objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        CourseSiteDbLoader loader = (CourseSiteDbLoader)this._pm.getLoader("CourseSiteLoader");
        CourseSite obj = new CourseSite();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        CourseSite CourseSite2 = (CourseSite)list.get(0);
        objInput.setBatchUid(CourseSite2.getBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (CourseSite obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

