/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.impl.soap.admincourse.ClientUtility;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.snapshot.persist.Results;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.RuntimeBbServiceException;
import blackboard.platform.soap.ServerResponse;
import blackboard.util.ObjectSerializer;

public class CourseSiteRemotePersister
extends AdminPersister
implements CourseSitePersister {
    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            try {
                super.init(pm, appVersion);
            }
            catch (RuntimeBbServiceException exc) {
                if (!this._lMgr.isLicensed("integration.apis")) break block2;
                throw exc;
            }
        }
    }

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid);
        ServerResponse response = this.executeSoapCall(req);
        return (String)response.getResults();
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, sessionId);
        this.executeSoapCall(req);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.closeSession(strSessionId);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        try {
            this.save((CourseSite)obj, strSessionId);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.save(objList, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        return this.resolveInternalId(objList, response, "admincourse.id.list");
    }

    public Results remove(BbList objList) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.remove(objList);
        ServerResponse response = this.executeSoapCall(req);
        return (Results)ObjectSerializer.deSerializeObject((String)((String)response.getResults()));
    }

    public void save(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void save(CourseSite objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        BbList bList = new BbList();
        bList.add((Object)objToSave);
        this.resolveInternalId(bList, response, "admincourse.id.list");
    }

    public void insert(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.insert(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void update(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.update(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void remove(CourseSite objToRemove) throws KeyNotFoundException, PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.remove(objToRemove);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public void changeKey(CourseSite objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        super.checkApiLicensing();
        objToSave.setReplacementBatchUid(newKey);
        this.update(objToSave);
    }

    public void clone(String srcCrsBatchUid, String tgtCrsBatchUid, CloneConfig cfg) throws PersistenceException, KeyNotFoundException, ValidationException, ConstraintViolationException {
        ClientUtility req = new ClientUtility();
        req.clone(srcCrsBatchUid, tgtCrsBatchUid, cfg);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }
}

