/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Membership;
import blackboard.admin.persist.course.EnrollmentLoader;
import blackboard.admin.persist.course.impl.MembershipSelectQuery;
import blackboard.admin.persist.course.impl.mapping.EnrollmentLoaderDbMap;
import blackboard.admin.persist.impl.AdminNewBaseDbLoader;
import blackboard.base.BbList;
import blackboard.base.ListFilter;
import blackboard.data.BbObject;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.SelectQuery;
import java.util.BitSet;

public class EnrollmentDbLoader
extends AdminNewBaseDbLoader
implements EnrollmentLoader {
    public Enrollment load(String crsBatchUid, String personBatchUid) throws KeyNotFoundException, PersistenceException {
        MembershipSelectQuery query = new MembershipSelectQuery(EnrollmentLoaderDbMap.MAP);
        query.addWhere("GroupBatchUid", crsBatchUid);
        query.addWhere("PersonBatchUid", personBatchUid);
        return (Enrollment)super.loadObject((SelectQuery)query, null);
    }

    public BbList load(Enrollment template) throws PersistenceException {
        BitSet filterSet = new BitSet(2);
        if (template.getBbAttributes().getBbAttribute("PersonalInfo").getIsDirty()) {
            template.getBbAttributes().getBbAttribute("PersonalInfo").setIsDirty(false);
            filterSet.set(0);
        }
        if (template.getBbAttributes().getBbAttribute("Notes").getIsDirty()) {
            template.getBbAttributes().getBbAttribute("Notes").setIsDirty(false);
            filterSet.set(1);
        }
        if (template.getBbAttributes().getBbAttribute("FavoriteLinks").getIsDirty()) {
            template.getBbAttributes().getBbAttribute("FavoriteLinks").setIsDirty(false);
            filterSet.set(2);
        }
        MembershipSelectQuery query = new MembershipSelectQuery(EnrollmentLoaderDbMap.MAP);
        query.init(this._bbDatabase, this._pm.getContainer());
        this.generateWhereClause((BbObject)template, query);
        BbList list = (BbList)super.loadList((SelectQuery)query, null);
        return list.getFilteredSubList((ListFilter)new MembershipFilter(template, filterSet));
    }

    protected static class MembershipFilter
    extends ListFilter {
        private Membership _template;
        private BitSet _filterSet;

        public MembershipFilter(Membership template, BitSet filterSet) {
            this._template = template;
            this._filterSet = filterSet;
        }

        protected boolean passesFilter(Object listElement) {
            Membership obj = (Membership)listElement;
            if (this._filterSet.get(0) && !this.compare(this._template.getPersonalInfo(), obj.getPersonalInfo())) {
                return false;
            }
            if (this._filterSet.get(1) && !this.compare(this._template.getNotes(), obj.getNotes())) {
                return false;
            }
            return !this._filterSet.get(2) || this.compare(this._template.getBbLinkAtPos(1).getName(), obj.getBbLinkAtPos(1).getName()) && this.compare(this._template.getBbLinkAtPos(1).getDescription(), obj.getBbLinkAtPos(1).getDescription()) && this.compare(this._template.getBbLinkAtPos(1).getUrl(), obj.getBbLinkAtPos(1).getUrl()) && this.compare(this._template.getBbLinkAtPos(2).getName(), obj.getBbLinkAtPos(2).getName()) && this.compare(this._template.getBbLinkAtPos(2).getDescription(), obj.getBbLinkAtPos(2).getDescription()) && this.compare(this._template.getBbLinkAtPos(2).getUrl(), obj.getBbLinkAtPos(2).getUrl()) && this.compare(this._template.getBbLinkAtPos(3).getName(), obj.getBbLinkAtPos(3).getName()) && this.compare(this._template.getBbLinkAtPos(3).getDescription(), obj.getBbLinkAtPos(3).getDescription()) && this.compare(this._template.getBbLinkAtPos(3).getUrl(), obj.getBbLinkAtPos(3).getUrl());
        }

        private boolean compare(String template, String obj) {
            if (template == null && obj != null) {
                return false;
            }
            if (template != null && obj == null) {
                return false;
            }
            if (template == null && obj == null) {
                return true;
            }
            template = template.toLowerCase();
            obj = obj.toLowerCase();
            int idx = template.indexOf("%");
            if (idx == -1) {
                return template.equals(obj);
            }
            idx = obj.indexOf(template);
            return idx != -1;
        }
    }
}

