/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.IMembership;
import blackboard.admin.data.course.Membership;
import blackboard.admin.data.course.MembershipXmlDef;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.persist.course.AdminCourseCourseXmlPersister;
import blackboard.admin.persist.course.EnrollmentXmlPersister;
import blackboard.admin.persist.course.OrganizationMembershipXmlPersister;
import blackboard.admin.persist.course.StaffAssignmentXmlPersister;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.base.BbList;
import blackboard.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MembershipXmlPersisterImpl
extends AdminPersister
implements MembershipXmlDef,
StaffAssignmentXmlPersister,
EnrollmentXmlPersister,
OrganizationMembershipXmlPersister,
AdminCourseCourseXmlPersister {
    public Element persist(OrganizationMembership obj, Document doc) {
        return this.persist((IMembership)obj, doc);
    }

    public Element persist(Enrollment obj, Document doc) {
        return this.persist((IMembership)obj, doc);
    }

    public Element persist(StaffAssignment obj, Document doc) {
        return this.persist((IMembership)obj, doc);
    }

    public Element persist(AdminCourseCourse obj, Document doc) {
        return this.persist((IMembership)obj, doc);
    }

    protected Element persistMember(IMembership obj, Document doc) {
        Element rootElement = doc.createElement("member");
        this.persistMemberSourceIdNode(obj, rootElement, doc);
        if (obj instanceof Membership) {
            Membership mem = (Membership)obj;
            this.persistRoleNode(mem, rootElement, doc);
        }
        this.persistExtensionNode(obj, rootElement, doc);
        return rootElement;
    }

    public Element persist(BbList objList, Document doc) {
        boolean bToggle = false;
        Element rootElement = doc.createElement("membership");
        for (IMembership tmp : objList) {
            if (!bToggle) {
                this.persistMembershipSourceIdNode(tmp, rootElement, doc);
                bToggle = false;
            }
            rootElement.appendChild(this.persistMember(tmp, doc));
        }
        return rootElement;
    }

    public Element persist(IMembership obj, Document doc) {
        Element rootElement = doc.createElement("membership");
        this.persistMembershipSourceIdNode(obj, rootElement, doc);
        rootElement.appendChild(this.persistMember(obj, doc));
        return rootElement;
    }

    protected void persistMembershipSourceIdNode(IMembership obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("sourcedid");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"source", (String)"Bb Platform");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"id", (String)obj.getParentBatchUid());
        rootElement.appendChild(childElement);
    }

    protected void persistMemberSourceIdNode(IMembership obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("sourcedid");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"source", (String)"Bb Platform");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"id", (String)obj.getChildBatchUid());
        rootElement.appendChild(childElement);
    }

    protected void persistRoleNode(Membership obj, Element rootElement, Document doc) {
        Element childElement = doc.createElement("role");
        if (obj.getBbAttributes().getBbAttribute("Role").getIsDirty()) {
            childElement.setAttribute("roletype", String.valueOf(ConversionUtility.courseMembershipRoleToInt(obj.getRole())));
        }
        this.persistStatusNode(obj, childElement, doc);
        rootElement.appendChild(childElement);
    }

    private void persistStatusNode(Membership obj, Element rootElement, Document doc) {
        if (obj.getBbAttributes().getBbAttribute("IsAvailable").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)rootElement, (String)"status", (String)String.valueOf(ConversionUtility.booleanToInt(obj.getIsAvailable())));
        }
    }

    protected void persistExtensionNode(IMembership obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("extension");
        if (obj.getBbAttributes().getBbAttribute("RowStatus").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_row_status", (String)String.valueOf(ConversionUtility.rowStatusToInt(obj.getRowStatus())));
        }
        if (obj.getBbAttributes().getBbAttribute("DataSourceBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_datasource_key", (String)obj.getDataSourceBatchUid());
        }
        if (obj.getDataSourceId().isSet()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_data_source_id", (String)obj.getDataSourceId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("id").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_id", (String)obj.getId().toExternalString());
        }
        if (obj instanceof Membership) {
            this.persistExtensionNode((Membership)obj, doc, childElement);
        }
        rootElement.appendChild(childElement);
    }

    protected void persistExtensionNode(Membership obj, Document doc, Element childElement) {
        if (obj.getBbAttributes().getBbAttribute("Introduction").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_introduction", (String)obj.getIntroduction());
        }
        if (obj.getBbAttributes().getBbAttribute("PersonalInfo").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_private_information", (String)obj.getPersonalInfo());
        }
        if (obj.getBbAttributes().getBbAttribute("Notes").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_notes", (String)obj.getNotes());
        }
        if (obj.getBbAttributes().getBbAttribute("HasCartridgeAccess").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_has_cartridge_access", (String)ConversionUtility.booleanToYN(obj.getHasCartridgeAccess()));
        }
        if (obj.getBbLinkAtPos(1).getBbAttributes().getBbAttribute("Name").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_name_1", (String)obj.getBbLinkAtPos(1).getName());
        }
        if (obj.getBbLinkAtPos(1).getBbAttributes().getBbAttribute("Url").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_url_1", (String)obj.getBbLinkAtPos(1).getUrl());
        }
        if (obj.getBbLinkAtPos(1).getBbAttributes().getBbAttribute("Description").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_desc_1", (String)obj.getBbLinkAtPos(1).getDescription());
        }
        if (obj.getBbLinkAtPos(2).getBbAttributes().getBbAttribute("Name").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_name_2", (String)obj.getBbLinkAtPos(2).getName());
        }
        if (obj.getBbLinkAtPos(2).getBbAttributes().getBbAttribute("Url").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_url_2", (String)obj.getBbLinkAtPos(2).getUrl());
        }
        if (obj.getBbLinkAtPos(2).getBbAttributes().getBbAttribute("Description").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_desc_2", (String)obj.getBbLinkAtPos(2).getDescription());
        }
        if (obj.getBbLinkAtPos(3).getBbAttributes().getBbAttribute("Name").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_name_3", (String)obj.getBbLinkAtPos(3).getName());
        }
        if (obj.getBbLinkAtPos(3).getBbAttributes().getBbAttribute("Url").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_url_3", (String)obj.getBbLinkAtPos(3).getUrl());
        }
        if (obj.getBbLinkAtPos(3).getBbAttributes().getBbAttribute("Description").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_link_desc_3", (String)obj.getBbLinkAtPos(3).getDescription());
        }
        if (obj.getBbAttributes().getBbAttribute("EnrollmentDate").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_enrollment_date", (String)TimeFormat.calendarToString(obj.getEnrollmentDate(), "yyyy-MM-dd"));
        }
        if (obj.getBbAttributes().getBbAttribute("LastAccessDate").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_last_access_date", (String)TimeFormat.calendarToString(obj.getLastAccessDate(), "yyyy-MM-dd"));
        }
        if (obj.getBbAttributes().getBbAttribute("CourseId").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_group_id", (String)obj.getBbAttributes().getSafeId("CourseId").toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("UserId").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_person_id", (String)obj.getUserId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("embed") != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_embedded_source", (String)obj.getBbAttributes().getSafeString("embed"));
        }
    }
}

