/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.Organization;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.OrganizationPersister;
import blackboard.admin.persist.course.impl.CourseSiteDbPersister;
import blackboard.admin.persist.course.impl.OrganizationDbLoader;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.mapping.AdminCourseDeleteDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCourseInsertDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCoursePersisterDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ImmutableException;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Query;
import blackboard.platform.BbServiceManager;
import blackboard.platform.RuntimeBbServiceException;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.util.ExceptionUtil;
import java.io.IOException;

public class OrganizationDbPersister
extends SnapshotDbPersister
implements OrganizationPersister {
    String[] CONSTRAINTS = new String[]{"COURSE_MAIN_PK", "COURSE_MAIN_AK1", "COURSE_MAIN_AK2", "COURSE_MAIN_AK3"};
    String[] IMMUTABLE = new String[]{"immutable"};

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            try {
                super.init(pm, appVersion);
            }
            catch (RuntimeBbServiceException exc) {
                if (!this._lMgr.isLicensed("integration.apis")) break block2;
                throw exc;
            }
        }
    }

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        super.checkApiLicensing();
        return super._createSession(dataSourceBatchUid, "course");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super.checkApiLicensing();
        super._createSession(dataSourceBatchUid, "course", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        super.closeSession(strSessionId, "course");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid((Organization)obj);
        try {
            super.save(AdminCoursePersisterDbMap.MAP, obj, strSessionId);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Organization id cannot be modified.");
            }
            throw pe;
        }
        this.resolveReplacementBatchUid((Organization)obj);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(AdminCoursePersisterDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        super.checkApiLicensing();
        try {
            OrganizationDbPersister.archiveOrganizationContent(objList);
        }
        catch (Exception exc) {
            BbServiceManager.getLogService().logWarning("Failure occurred during organization archival", (Throwable)exc);
        }
        return super.remove(AdminCourseDeleteDbMap.MAP, objList);
    }

    public void save(Organization objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
        }
        catch (PersistenceException e) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)e, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Organization id cannot be modified.");
            }
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    public void save(Organization objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.checkApiLicensing();
        try {
            super.save(AdminCoursePersisterDbMap.MAP, objToSave, strSessionId);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Organization id cannot be modified.");
            }
            throw pe;
        }
    }

    public void insert(Organization objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(AdminCourseInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void update(Organization objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
        }
        catch (PersistenceException e) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)e, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Organization id cannot be modified.");
            }
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    private void resolveReplacementBatchUid(Organization objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    public void remove(Organization objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        super.checkApiLicensing();
        try {
            OrganizationDbPersister.archiveOrganizationContent(objToRemove);
        }
        catch (Exception exc) {
            BbServiceManager.getLogService().logWarning("Failure occurred during organization archival", (Throwable)exc);
        }
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(AdminCourseDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    public void changeKey(Organization objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        super.checkApiLicensing();
        objToSave.setReplacementBatchUid(newKey);
        try {
            this.update(objToSave);
        }
        catch (PersistenceException e) {
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    public void clone(String srcOrgBatchUid, String tgtOrgBatchUid, CloneConfig cfg) throws PersistenceException, KeyNotFoundException, ValidationException, ConstraintViolationException {
        AdminCourseCloneOperator op = new AdminCourseCloneOperator(this._pm, this._appVersion);
        CourseDbLoader loader = (CourseDbLoader)this._pm.getLoader("CourseDbLoader");
        Course src = loader.loadByBatchUid(srcOrgBatchUid);
        Course tgt = loader.loadByBatchUid(tgtOrgBatchUid);
        try {
            op.clone(cfg, src, tgt);
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }

    protected static void archiveOrganizationContent(BbList list) throws PersistenceException, IOException, FileSystemException {
        CourseSiteDbPersister.archiveCourseContent(list);
    }

    protected static void archiveOrganizationContent(AdminCourse crs) throws PersistenceException, IOException, FileSystemException {
        CourseSiteDbPersister.archiveCourseContent(crs);
    }

    private void resolveBatchUid(Organization objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        OrganizationDbLoader loader = (OrganizationDbLoader)this._pm.getLoader("OrganizationLoader");
        Organization obj = new Organization();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        Organization Organization2 = (Organization)list.get(0);
        objInput.setBatchUid(Organization2.getBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (Organization obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

