/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.persist.course.CourseEventListener;
import blackboard.data.course.Course;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Id;
import blackboard.platform.BbServiceManager;
import blackboard.platform.extension.service.ExtensionRegistryFactory;
import blackboard.platform.queue.BaseQueuedOperation;
import blackboard.platform.queue.QueuedOperation;
import blackboard.platform.queue.data.QueueTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PostCourseCreateOperation
extends BaseQueuedOperation
implements QueuedOperation {
    public static final String COURSE_ARG = "course.id";
    static List<CourseEventListener> _handlerClasses = new ArrayList<CourseEventListener>();

    public String execute(QueueTask task) {
        String results = "copy.msg.post.operation.successful";
        try {
            Iterator<CourseEventListener> handlerIt = _handlerClasses.iterator();
            Id courseId = null;
            BbPersistenceManager pm = BbServiceManager.getPersistenceService().getDbPersistenceManager();
            courseId = pm.generateId(Course.DATA_TYPE, task.getArguments());
            while (handlerIt.hasNext()) {
                try {
                    CourseEventListener listener = handlerIt.next();
                    listener.courseCreated(courseId);
                }
                catch (Throwable t) {
                    BbServiceManager.getLogService().logError("Error processing event handler", t);
                    results = "copy.msg.post.operation.error";
                }
            }
            this._status = QueueTask.Status.COMPLETE;
        }
        catch (Throwable e) {
            BbServiceManager.getLogService().logError("An error occurred during event processing " + task);
            this._status = QueueTask.Status.COMPLETE_ERRORS;
        }
        return "copy|" + results;
    }

    public String getStatusDetail(String locale) {
        return "";
    }

    public String getStatusSummary(String locale) {
        return "";
    }

    static {
        try {
            Collection courseEventListeners = ExtensionRegistryFactory.getInstance().getExtensions("blackboard.cmsadmin.postCreateCourseEventListener");
            for (CourseEventListener courseEventListener : courseEventListeners) {
                _handlerClasses.add(courseEventListener);
            }
        }
        catch (Exception e) {
            BbServiceManager.getLogService().logWarning("Could not load event handlers", (Throwable)e);
        }
    }
}

