/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.persist.course.StaffAssignmentPersister;
import blackboard.admin.persist.course.impl.StaffAssignmentDbLoader;
import blackboard.admin.persist.course.impl.mapping.MembershipDeleteDbMap;
import blackboard.admin.persist.course.impl.mapping.StaffAssignmentDbMap;
import blackboard.admin.persist.course.impl.mapping.StaffAssignmentInsertDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;

public class StaffAssignmentDbPersister
extends SnapshotDbPersister
implements StaffAssignmentPersister {
    String[] CONSTRAINTS = new String[]{"COURSE_USERS_PK", "COURSE_USERS_AK1"};

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "cu");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "cu", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "cu");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((StaffAssignment)obj);
        super.save(StaffAssignmentDbMap.MAP, obj, strSessionId);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(StaffAssignmentDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return super.remove(MembershipDeleteDbMap.MAP, objList);
    }

    public void save(StaffAssignment objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(StaffAssignmentDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void save(StaffAssignment objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(StaffAssignmentDbMap.MAP, objToSave, strSessionId);
    }

    public void insert(StaffAssignment objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(StaffAssignmentInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void update(StaffAssignment objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(StaffAssignmentDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void remove(StaffAssignment objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(MembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(StaffAssignment objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("PersonBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("GroupBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        StaffAssignmentDbLoader loader = (StaffAssignmentDbLoader)this._pm.getLoader("StaffAssignmentLoader");
        StaffAssignment obj = new StaffAssignment();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        StaffAssignment StaffAssignment2 = (StaffAssignment)list.get(0);
        objInput.setCourseSiteBatchUid(StaffAssignment2.getCourseSiteBatchUid());
        objInput.setPersonBatchUid(StaffAssignment2.getPersonBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (StaffAssignment obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

