/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.persist.course.StaffAssignmentPersister;
import blackboard.admin.persist.course.impl.soap.membership.ClientUtility;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.snapshot.persist.Results;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.soap.ServerResponse;
import blackboard.util.ObjectSerializer;

public class StaffAssignmentRemotePersister
extends AdminPersister
implements StaffAssignmentPersister {
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid);
        ServerResponse response = this.executeSoapCall(req);
        return (String)response.getResults();
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, sessionId);
        this.executeSoapCall(req);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.closeSession(strSessionId);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        try {
            this.save((StaffAssignment)obj, strSessionId);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.save(objList, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        return this.resolveInternalId(objList, response, "membership.id.list");
    }

    public Results remove(BbList objList) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove(objList);
        ServerResponse response = this.executeSoapCall(req);
        return (Results)ObjectSerializer.deSerializeObject((String)((String)response.getResults()));
    }

    public void save(StaffAssignment objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void save(StaffAssignment objToSave, String strSessionId) throws PersistenceException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        BbList bList = new BbList();
        bList.add((Object)objToSave);
        this.resolveInternalId(bList, response, "membership.id.list");
    }

    public void insert(StaffAssignment objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.insert(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void update(StaffAssignment objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.update(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void remove(StaffAssignment objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove(objToRemove);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }
}

