/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.persist.course.impl.clone.DebugCloneCallback;
import blackboard.admin.persist.course.impl.clone.operator.AnnouncementCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.AssessmentCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.AvailabilityRuleCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CalendarCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CategoryMembershipCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ChatArchiveCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ChatSessionCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ContentCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ContentTocCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseCorrectionCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseStatisticsCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseTocCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.CourseTocOrderingOperator;
import blackboard.admin.persist.course.impl.clone.operator.DiscussionBoardCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.DropBoxCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.EWSCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.FileManagerCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.GlossaryCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.GradebookCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.GroupCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.LinkCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.MembershipCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ReconciliationCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.SettingCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.StaffInformationCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.TaskCloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.course.Course;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import blackboard.platform.log.LogService;
import blackboard.platform.queue.QueuedTaskManager;
import blackboard.platform.queue.data.QueueTask;
import blackboard.util.FileUtil;
import blackboard.util.ObjectSerializer;
import blackboard.util.UuidFactory;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AdminCourseCloneOperator
extends CloneOperator {
    private String _sessionId;
    private Map<String, Map<String, String>> _dbBasedIdMap = new HashMap<String, Map<String, String>>();
    private ArrayList<CloneOperator> _operatorList = new ArrayList(18);
    private AsynchronousDirectoryClone _thread;

    public AdminCourseCloneOperator(BbPersistenceManager pm, AppVersion appVersion) {
        super(pm, appVersion);
        this._operatorList.add(new CategoryMembershipCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new MembershipCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new GroupCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new AnnouncementCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new CalendarCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new ContentCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new ReconciliationCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new StaffInformationCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new CourseTocCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new ContentTocCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new DiscussionBoardCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new AssessmentCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new GradebookCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new EWSCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new SettingCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new LinkCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new DropBoxCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new FileManagerCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new TaskCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new ChatSessionCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new ChatArchiveCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new CourseStatisticsCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new GlossaryCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new CourseTocOrderingOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new AvailabilityRuleCloneOperator(pm, appVersion, this._dbBasedIdMap));
        this._operatorList.add(new CourseCorrectionCloneOperator(pm, appVersion, this._dbBasedIdMap));
    }

    public void init(Course src, Course tgt, String sessionId, CloneCallback callback) {
        super.init(src, tgt, sessionId, callback);
        CloneOperator[] operators = new CloneOperator[this._operatorList.size()];
        this._operatorList.toArray(operators);
        for (int cnt = 0; cnt < operators.length; ++cnt) {
            operators[cnt].init(src, tgt, this._sessionId, callback);
        }
    }

    public void clone(CloneConfig cfg, Course srcCourse, Course tgtCourse) throws PersistenceException, ConnectionNotAvailableException {
        if (srcCourse.getBatchUid().equals(tgtCourse.getBatchUid())) {
            throw new PersistenceException(ConfigurationManager.getGlobalLocaleExceptionMessage("clone.invalidtarget"));
        }
        if (this._bDebug && cfg.getCallback() == null) {
            cfg.setCallback(new DebugCloneCallback());
        }
        long lStart = 0L;
        long oStart = System.currentTimeMillis();
        try {
            CourseTocDbLoader loader = CourseTocDbLoader.Default.getInstance();
            BbList list = loader.loadByCourseId(tgtCourse.getId());
            cfg.setOriginalTargetCourseTocList((ArrayList)list);
            this._sessionId = this.createSession();
            this.init(srcCourse, tgtCourse, this._sessionId, cfg.getCallback());
            File srcPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._srcSite.getCourseId());
            File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
            this._thread = new AsynchronousDirectoryClone(cfg, srcPath, tgtPath);
            this._thread.start();
            this.doDatabaseTranslation(cfg);
            lStart = System.currentTimeMillis();
            this.loadMapping();
            this.doCallbackSegment(CloneCallback.Stage.LOAD_ID_MAP, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.map.load"), System.currentTimeMillis() - lStart);
            lStart = System.currentTimeMillis();
            this.doContentDirectoryTranslation(cfg);
            this.doCallbackSegment(CloneCallback.Stage.FILE_COPY, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.file"), System.currentTimeMillis() - lStart);
            this.doEmbeddedDatabaseIdTranslation(cfg);
            this.doPostEvent(srcCourse, tgtCourse, cfg);
        }
        catch (Exception e) {
            throw new PersistenceException(ConfigurationManager.getGlobalLocaleExceptionMessage("clone.general.failure"), (Throwable)e);
        }
        finally {
            this.releaseResources();
        }
        this.doCallbackSegment(CloneCallback.Stage.TERMINUS, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.exit"), System.currentTimeMillis() - oStart);
    }

    private void doPostEvent(Course srcCourse, Course tgtCourse, CloneConfig cfg) {
        if (cfg.getSuppressEvents()) {
            return;
        }
        try {
            HashMap<String, Object> argMap = new HashMap<String, Object>();
            argMap.put("source.id", srcCourse.getId().toExternalString());
            argMap.put("target.id", tgtCourse.getId().toExternalString());
            argMap.put("clone.config", cfg);
            QueuedTaskManager qtm = (QueuedTaskManager)BbServiceManager.lookupService(QueuedTaskManager.class);
            QueueTask task = new QueueTask();
            task.setArguments(ObjectSerializer.serializeObject(argMap));
            task.setTitle("copy|copy.msg.postclone.event|" + tgtCourse.getCourseId());
            task.setType(QueueTask.Type.CC_POST_EVENT);
            qtm.addTask(task);
        }
        catch (Exception e) {
            BbServiceManager.getLogService().logError("Could not post course copy event.");
        }
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        CloneOperator[] operators = new CloneOperator[this._operatorList.size()];
        this._operatorList.toArray(operators);
        for (int cnt = 0; cnt < operators.length; ++cnt) {
            operators[cnt].doDatabaseTranslation(cfg);
        }
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
        CloneOperator[] operators = new CloneOperator[this._operatorList.size()];
        this._operatorList.toArray(operators);
        for (int cnt = 0; cnt < operators.length; ++cnt) {
            operators[cnt].doEmbeddedDatabaseIdTranslation(cfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapping() throws Exception {
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rst = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement("select * from tmp_key_maps where session_id = ? and table_name in ('QTI_ASI_DATA', 'VC_ARCHIVE_EVENT', 'COURSE_CONTENTS', 'FILES' ,'MSG_MAIN', 'GROUPS', 'ATTEMPT', 'STAFFINFORMATION', 'COURSE_USERS', 'COURSE_TOC' ) order by table_name desc");
            DbUtil.setString((PreparedStatement)stmt, (int)1, (String)this._sessionId);
            rst = stmt.executeQuery();
            while (rst.next()) {
                Id oldId = Bb5Util.unmarshallId((ResultSet)rst, (String)"old_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                String name = rst.getString("table_name");
                Map<String, String> tmp = null;
                tmp = this._dbBasedIdMap.get(name);
                if (tmp == null) {
                    tmp = new HashMap<String, String>();
                    this._dbBasedIdMap.put(name, tmp);
                }
                if (oldId == null || newId == null) continue;
                tmp.put(oldId.toExternalString(), newId.toExternalString());
            }
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put(this._srcSite.getId().toExternalString(), this._tgtSite.getId().toExternalString());
            this._dbBasedIdMap.put("COURSE_MAIN", tmp);
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rst);
            DbUtil.closeStatement(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.closeResultSet((ResultSet)rst);
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        File srcPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._srcSite.getCourseId());
        this._thread.join();
        if (this._thread.getException() != null) {
            throw this._thread.getException();
        }
        CloneOperator[] operators = new CloneOperator[this._operatorList.size()];
        this._operatorList.toArray(operators);
        for (int cnt = 0; cnt < operators.length; ++cnt) {
            operators[cnt].doContentDirectoryTranslation(cfg);
        }
        File cacheFile = new File(srcPath, "nav_item_courses.db");
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    private String createSession() throws Exception {
        return UuidFactory.createUuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResources() {
        block7: {
            if (this._sessionId == null) {
                return;
            }
            if (BbServiceManager.getLogService().getVerbosityLevel() == LogService.Verbosity.DEBUG) {
                return;
            }
            PreparedStatement stmt = null;
            Connection con = null;
            try {
                con = this._bbDatabase.getConnectionManager().getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("delete from tmp_key_maps where session_id = ?");
                stmt.setString(1, this._sessionId);
                stmt.execute();
                con.commit();
                DbUtil.closeStatement((Statement)stmt);
            }
            catch (Exception exc) {
                BbServiceManager.getLogService().logWarning(exc.getLocalizedMessage(), (Throwable)exc);
                break block7;
            }
            finally {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
            }
            this._bbDatabase.getConnectionManager().releaseConnection(con);
        }
    }

    private class AsynchronousDirectoryClone
    extends Thread {
        private Exception _exc;
        private File _srcPath;
        private File _tgtPath;
        private CloneConfig _cfg;

        public AsynchronousDirectoryClone(CloneConfig cfg, File srcPath, File tgtPath) {
            this._srcPath = srcPath;
            this._tgtPath = tgtPath;
            this._cfg = cfg;
        }

        public void run() {
            try {
                if (this._cfg.isAreaIncluded(CloneConfig.Area.ASSESSMENT)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "assessment"), (File)new File(this._tgtPath, "assessment"));
                    FileUtil.copyDirectory((File)new File(this._srcPath, "assignment"), (File)new File(this._tgtPath, "assignment"));
                    FileUtil.copyDirectory((File)new File(this._srcPath, "ppg"), (File)new File(this._tgtPath, "ppg"));
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.CHAT_ARCHIVE)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "collab" + File.separator + "archives"), (File)new File(this._tgtPath, "collab" + File.separator + "archives"));
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "content"), (File)new File(this._tgtPath, "content"));
                    if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
                        FileUtil.copyDirectory((File)new File(this._srcPath, "messaging"), (File)new File(this._tgtPath, "messaging"));
                    }
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.DISCUSSION_BOARD) || this._cfg.isAreaIncluded(CloneConfig.Area.DISCUSSION_BOARD_ARCHIVE)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "db"), (File)new File(this._tgtPath, "db"));
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "uploads"), (File)new File(this._tgtPath, "uploads"));
                    if (this._cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
                        FileUtil.copyDirectory((File)new File(this._srcPath, "groups"), (File)new File(this._tgtPath, "groups"));
                    }
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT) && !this._cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "uploads" + File.separator + "homepage"), (File)new File(this._tgtPath, "uploads" + File.separator + "homepage"));
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "gradebook"), (File)new File(this._tgtPath, "gradebook"));
                    if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP) && this._cfg.isAreaIncluded(CloneConfig.Area.GRADES)) {
                        FileUtil.copyDirectory((File)new File(this._srcPath, "attempt"), (File)new File(this._tgtPath, "attempt"));
                    }
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.SETTING) || this._cfg.isAreaIncluded(CloneConfig.Area.GLOSSARY)) {
                    CloneOperator.copyCourseGlossaryAndSettings(this._srcPath, this._tgtPath, this._cfg);
                }
                if (this._cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION)) {
                    FileUtil.copyDirectory((File)new File(this._srcPath, "staffinformation"), (File)new File(this._tgtPath, "staffinformation"));
                }
            }
            catch (Exception exc) {
                this._exc = exc;
            }
        }

        public Exception getException() {
            return this._exc;
        }
    }
}

