/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.operator.GlossaryCloneOperator;
import blackboard.base.AppVersion;
import blackboard.base.InitializationException;
import blackboard.data.course.Course;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.DatabaseContainer;
import blackboard.persist.Id;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.BbServiceManager;
import blackboard.platform.log.LogService;
import blackboard.util.FileUtil;
import blackboard.util.TextFormat;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class CloneOperator {
    public static final String SOS_PK2 = "1";
    protected BbDatabase _bbDatabase;
    protected BbPersistenceManager _pm;
    protected AppVersion _appVersion;
    protected Map _dbBasedIdMap;
    protected Course _srcSite;
    protected Course _tgtSite;
    protected CloneCallback _callback;
    protected String _sessionId;
    protected boolean _bDebug = false;

    public CloneOperator(BbPersistenceManager pm, AppVersion appVersion) {
        this._pm = pm;
        this._appVersion = appVersion;
        this._bbDatabase = ((DatabaseContainer)pm.getContainer()).getBbDatabase();
        if (BbServiceManager.getLogService().getVerbosityLevel() == LogService.Verbosity.DEBUG) {
            this._bDebug = true;
        }
    }

    public CloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        this._pm = pm;
        this._appVersion = appVersion;
        this._bbDatabase = ((DatabaseContainer)pm.getContainer()).getBbDatabase();
        this._dbBasedIdMap = dbBasedIdMap;
        if (BbServiceManager.getLogService().getVerbosityLevel() == LogService.Verbosity.DEBUG) {
            this._bDebug = true;
        }
    }

    protected void init(Course src, Course tgt, String sessionId, CloneCallback callback) {
        this._srcSite = src;
        this._tgtSite = tgt;
        this._sessionId = sessionId;
        this._callback = callback;
    }

    public abstract void doDatabaseTranslation(CloneConfig var1) throws Exception;

    public abstract void doEmbeddedDatabaseIdTranslation(CloneConfig var1) throws Exception;

    public abstract String getDirectoryTranslation(String var1);

    public abstract void doContentDirectoryTranslation(CloneConfig var1) throws Exception;

    protected void doCallbackSegment(CloneCallback.Stage stage, String msg, long interval) {
        if (this._callback == null) {
            return;
        }
        this._callback.callback(stage, msg, interval);
    }

    protected void executeCloneProcedure(String procedureName, int commitFrequency) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CloneQuery.getCloneQuery(procedureName, con);
            CloneQuery.marshallParams(this._srcSite, this._tgtSite, this._sessionId, commitFrequency, stmt);
            stmt.execute();
            con.commit();
        }
        catch (SQLException sqe) {
            try {
                DbUtil.rollbackConnection((Connection)con);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected void executeCloneProcedure(String procedureName, int commitFrequency, String withProtectedCartridge) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CloneQuery.getCloneQuery(procedureName, con, withProtectedCartridge);
            CloneQuery.marshallParams(this._srcSite, this._tgtSite, this._sessionId, commitFrequency, stmt, withProtectedCartridge);
            stmt.execute();
            con.commit();
        }
        catch (SQLException sqe) {
            try {
                DbUtil.rollbackConnection((Connection)con);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected void doDirectoryPathTranslation(String strDirectory) throws Exception {
        File sourceDir = new File(strDirectory);
        String[] straAllFiles = FileUtil.getDirectoryListing((File)sourceDir);
        if (straAllFiles == null || straAllFiles.length == 0) {
            return;
        }
        for (int i = 0; i < straAllFiles.length; ++i) {
            File sourceFile;
            if (!this.existsInTarget(straAllFiles[i]) || (sourceFile = new File(straAllFiles[i])).isFile()) continue;
            String strDestinationFile = this.getDirectoryTranslation(sourceFile.getPath());
            this.renameFile(sourceFile, new File(strDestinationFile));
        }
    }

    protected void renameFile(File orig, File target) throws Exception {
        if (!orig.renameTo(target)) {
            if (orig.isDirectory()) {
                FileUtil.moveDirectory((File)orig, (File)target);
            } else {
                FileUtil.moveFile((File)orig, (File)target);
            }
        }
    }

    protected boolean existsInTarget(String strPath) {
        String origPath = TextFormat.replace((String)strPath, (String)this._tgtSite.getCourseId(), (String)this._srcSite.getCourseId());
        File origFile = new File(origPath);
        return origFile.exists();
    }

    protected Matcher getIdMatches(String text) {
        Matcher m = null;
        try {
            m = Pattern.compile("_+(\\d+)_+(\\d+)").matcher(text);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return m;
    }

    protected String resolveFileBasedMapping(Map map, String src) {
        if (map == null || src == null) {
            return src;
        }
        Matcher matches = this.getIdMatches(src);
        String value = null;
        String key = null;
        while (matches.find()) {
            value = (String)map.get(matches.group(0));
            if (value == null) continue;
            if (FileUtil.os == 1 || FileUtil.os == 0) {
                key = File.separator + File.separator + matches.group(0);
                value = File.separator + File.separator + value;
            } else {
                key = File.separator + matches.group(0);
                value = File.separator + value;
            }
            src = TextFormat.replace((String)src, (String)key, (String)value);
        }
        return src;
    }

    protected static void copyCourseGlossaryAndSettings(File in, File out, CloneConfig cfg) throws IOException, InitializationException {
        String[] fileList;
        if (!in.exists()) {
            return;
        }
        if (!out.exists()) {
            out.mkdirs();
        }
        if ((fileList = in.list()).length == 0) {
            return;
        }
        for (int cnt = 0; cnt < fileList.length; ++cnt) {
            File srcFile = new File(in, fileList[cnt]);
            if (!srcFile.exists() || srcFile.isDirectory()) continue;
            if (fileList[cnt].equalsIgnoreCase(GlossaryCloneOperator.GLOSSARY_PROPERTIES)) {
                if (!cfg.isAreaIncluded(CloneConfig.Area.GLOSSARY)) continue;
                Properties tgt = new Properties();
                File tgtFile = new File(out, fileList[cnt]);
                tgtFile.createNewFile();
                FileUtil.addPropertiesFromFile((Properties)tgt, (File)tgtFile, (boolean)true);
                FileUtil.addPropertiesFromFile((Properties)tgt, (File)srcFile, (boolean)true);
                FileUtil.writePropertyFile((File)tgtFile, (Properties)tgt);
                continue;
            }
            if (!cfg.isAreaIncluded(CloneConfig.Area.SETTING)) continue;
            FileUtil.copyFile((File)srcFile, (File)new File(out, fileList[cnt]));
        }
    }

    protected String resolveTextBasedMapping(Map map, String src) {
        if (map == null || src == null) {
            return src;
        }
        Matcher matches = this.getIdMatches(src);
        String value = null;
        while (matches.find()) {
            value = (String)map.get(matches.group(0));
            if (value == null) continue;
            src = TextFormat.replace((String)src, (String)matches.group(0), (String)value);
        }
        return src;
    }

    protected class AsynchronousDirectoryClone
    extends Thread {
        private Map<File, File> _map = new HashMap<File, File>();
        StringBuffer _sb = new StringBuffer();

        public void addPaths(File srcPath, File tgtPath) {
            this._map.put(srcPath, tgtPath);
        }

        public void run() {
            for (File srcPath : this._map.keySet()) {
                File tgtPath = this._map.get(srcPath);
                try {
                    FileUtil.jCopyDirectory((File)srcPath, (File)tgtPath);
                }
                catch (Exception exc) {
                    this._sb.append(exc.getLocalizedMessage());
                    this._sb.append(" ");
                }
            }
        }

        public Exception getException() {
            if (this._sb.length() > 0) {
                return new Exception(this._sb.toString());
            }
            return null;
        }
    }

    static class CloneQuery {
        CloneQuery() {
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con) throws SQLException {
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con, String withProtectedCartridge) throws SQLException {
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, String sessionId, int commitFrequency, CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            stmt.setInt(3, commitFrequency);
            stmt.setString(4, sessionId);
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, String sessionId, int commitFrequency, CallableStatement stmt, String withProtectedCartridge) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            stmt.setInt(3, commitFrequency);
            stmt.setString(4, sessionId);
            stmt.setString(5, withProtectedCartridge);
        }
    }
}

