/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseEventListener;
import blackboard.data.course.Course;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Id;
import blackboard.platform.BbServiceManager;
import blackboard.platform.extension.service.ExtensionRegistryFactory;
import blackboard.platform.queue.BaseQueuedOperation;
import blackboard.platform.queue.QueuedOperation;
import blackboard.platform.queue.data.QueueTask;
import blackboard.util.ObjectSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PostCourseCloneOperation
extends BaseQueuedOperation
implements QueuedOperation {
    public static final String SOURCE_ARG = "source.id";
    public static final String TARGET_ARG = "target.id";
    public static final String CONFIG_ARG = "clone.config";
    static List<CourseEventListener> _handlerClasses = new ArrayList<CourseEventListener>();

    public PostCourseCloneOperation() {
        this._status = QueueTask.Status.COMPLETE;
    }

    public String execute(QueueTask task) {
        String results = "copy.msg.post.operation.successful";
        try {
            Iterator<CourseEventListener> handlerIt = _handlerClasses.iterator();
            Id sourceId = null;
            Id targetId = null;
            CloneConfig config = null;
            Map argMap = this.getArguments(task.getArguments());
            BbPersistenceManager pm = BbServiceManager.getPersistenceService().getDbPersistenceManager();
            sourceId = pm.generateId(Course.DATA_TYPE, (String)argMap.get(SOURCE_ARG));
            targetId = pm.generateId(Course.DATA_TYPE, (String)argMap.get(TARGET_ARG));
            config = (CloneConfig)argMap.get(CONFIG_ARG);
            while (handlerIt.hasNext()) {
                try {
                    CourseEventListener listener = handlerIt.next();
                    listener.courseCloned(sourceId, targetId, config);
                }
                catch (Throwable t) {
                    BbServiceManager.getLogService().logError("Error processing event handler", t);
                    results = "copy.msg.clone.operation.error";
                }
            }
        }
        catch (Throwable e) {
            BbServiceManager.getLogService().logError("An error occurred during event processing " + task);
        }
        return "copy|" + results;
    }

    public String getStatusDetail(String strLocale) {
        return "";
    }

    public String getStatusSummary(String strLocale) {
        return "";
    }

    private Map getArguments(String args) {
        HashMap argMap = null;
        try {
            argMap = (HashMap)ObjectSerializer.deSerializeObject((String)args);
        }
        catch (Exception e) {
            argMap = new HashMap();
        }
        return argMap;
    }

    static {
        try {
            Collection courseEventListeners = ExtensionRegistryFactory.getInstance().getExtensions("blackboard.cmsadmin.postCloneCourseEventListener");
            for (CourseEventListener courseEventListener : courseEventListeners) {
                _handlerClasses.add(courseEventListener);
            }
        }
        catch (Exception e) {
            BbServiceManager.getLogService().logWarning("Could not load event handlers", (Throwable)e);
        }
    }
}

