/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.platform.BbServiceManager;
import blackboard.platform.queue.BaseQueuedOperation;
import blackboard.platform.queue.QueuedOperation;
import blackboard.platform.queue.data.QueueTask;
import blackboard.util.ObjectSerializer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class QueuedCloneOperation
extends BaseQueuedOperation
implements QueuedOperation {
    public static final String SOURCE_ARG = "src.clone";
    public static final String TARGET_ARG = "tgt.clone";
    public static final String CONFIG_ARG = "cfg.clone";
    public static final String CARTRIDGE_CONFLICT = "cfg.different.cartridge";
    private Map _args;
    private boolean _cartridge_conflict = false;

    public String execute(QueueTask task) {
        String results = "copy.msg.clone.operation.success";
        this._task = task;
        try {
            this._args = (Map)ObjectSerializer.deSerializeObject((String)task.getArguments());
            CourseSitePersister persister = (CourseSitePersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("CourseSitePersister");
            persister.clone((String)this._args.get(SOURCE_ARG), (String)this._args.get(TARGET_ARG), (CloneConfig)this._args.get(CONFIG_ARG));
            if (this._args.get(CARTRIDGE_CONFLICT) != null && ((String)this._args.get(CARTRIDGE_CONFLICT)).equals("Y")) {
                this._cartridge_conflict = true;
            }
            this._status = QueueTask.Status.COMPLETE;
        }
        catch (Throwable t) {
            BbServiceManager.getLogService().logError("Error cloning course.", t);
            results = "copy.msg.clone.operation.error";
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            t.printStackTrace(pw);
            this._status = QueueTask.Status.COMPLETE_ERRORS;
        }
        return "copy|" + results;
    }

    public String getStatusSummary(String strLocale) {
        if (this._status == QueueTask.Status.COMPLETE || this._status == QueueTask.Status.COMPLETE_ERRORS) {
            return this.buildString(strLocale, "platform", "platform.queuetask.notify.subject.course-copy");
        }
        return this.buildString(strLocale, "platform", "platform.queuetask.notify.subject.failed.course-copy");
    }

    public String getStatusDetail(String strLocale) {
        String title = this._task.getTitle(strLocale);
        String result = "";
        result = this._status == QueueTask.Status.COMPLETE || this._status == QueueTask.Status.COMPLETE_ERRORS ? this.buildString(strLocale, "platform", "platform.queuetask.notify.message.course-copy", new Object[]{title}) : this.buildString(strLocale, "platform", "platform.queuetask.notify.message.failed.course-copy", new Object[]{title});
        if (this._cartridge_conflict) {
            result = result + "\n\n";
            result = result + this.buildString(strLocale, "platform", "platform.queuetask.notify.message.course-copy.bothCartridge.differentCKey");
        }
        return result;
    }
}

