/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import java.io.File;
import java.util.Map;

public class AssessmentCloneOperator
extends CloneOperator {
    public AssessmentCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.ASSESSMENT)) {
            return;
        }
        this.executeCloneProcedure("category_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("c_creation_setting_cp", cfg.getMaximumTransactionCount());
        String flag = "N";
        if (cfg.isAreaIncluded(CloneConfig.Area.ASSESSEMENT_CARTRIDGE)) {
            flag = "Y";
        }
        this.executeCloneProcedure("qti_asi_data_cp", cfg.getMaximumTransactionCount(), flag);
        this.executeCloneProcedure("item_category_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_assessment_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("a_creation_setting_cp", cfg.getMaximumTransactionCount());
        this.doCallbackSegment(CloneCallback.Stage.ASSESSMENT, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.assessment"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        Map tmp = null;
        tmp = (Map)this._dbBasedIdMap.get("QTI_ASI_DATA");
        return this.resolveTextBasedMapping(tmp, dir);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.ASSESSMENT)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "assessment");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
        tgtPath = new File(tgtPath, "assignment");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

