/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import java.util.Map;

public class AvailabilityRuleCloneOperator
extends CloneOperator {
    public AvailabilityRuleCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.AVAILABILITY_RULE)) {
            return;
        }
        this.executeCloneProcedure("avl_rule_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("avl_crit_cp", cfg.getMaximumTransactionCount());
        if (cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
            this.executeCloneProcedure("avl_crit_acl_group_cp", cfg.getMaximumTransactionCount());
        }
        this.executeCloneProcedure("avl_crit_acl_portal_role_cp", cfg.getMaximumTransactionCount());
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("avl_crit_acl_user_cp", cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.AVAILABILITY_RULE, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.availabilityrule"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

