/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import java.io.File;
import java.util.Map;

public class ChatArchiveCloneOperator
extends CloneOperator {
    public ChatArchiveCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.CHAT_ARCHIVE)) {
            return;
        }
        this.executeCloneProcedure("course_collab_archive_desc_cp", cfg.getMaximumTransactionCount());
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("course_vc_archive_event_cp", cfg.getMaximumTransactionCount());
        }
        if (cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
            this.executeCloneProcedure("group_collab_archive_desc_cp", cfg.getMaximumTransactionCount());
            if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
                this.executeCloneProcedure("group_vc_archive_event_cp", cfg.getMaximumTransactionCount());
            }
        }
        this.doCallbackSegment(CloneCallback.Stage.CHAT_ARCHIVE, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.chat.log"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        Map tmp = null;
        tmp = (Map)this._dbBasedIdMap.get("VC_ARCHIVE_EVENT");
        return this.resolveTextBasedMapping(tmp, dir);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.CHAT_ARCHIVE)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "collab" + File.separator + "archives");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

