/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.course.Course;
import blackboard.data.navigation.CourseToc;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import blackboard.util.FileUtil;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class ContentCloneOperator
extends CloneOperator {
    public ContentCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
            return;
        }
        this.executeCartridgeCloneProcedure("course_contents_cp", cfg);
        this.executeCloneProcedure("files_ccf_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_contents_files_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("files_registries_ccf_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_contents_reviewed_cp", cfg.getMaximumTransactionCount());
        this.updateCourseCartridgeId();
        this.doCallbackSegment(CloneCallback.Stage.CONTENT, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.content"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "content");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    protected void doDirectoryPathTranslation(String strDirectory) throws Exception {
        Map contentsMap = (Map)this._dbBasedIdMap.get("COURSE_CONTENTS");
        File sourceDir = new File(strDirectory);
        String[] fileListing = FileUtil.getDirectoryListing((File)sourceDir);
        if (fileListing == null || fileListing.length == 0) {
            return;
        }
        for (int i = 0; i < fileListing.length; ++i) {
            File sourceFile;
            if (!this.existsInTarget(fileListing[i]) || (sourceFile = new File(fileListing[i])).isFile()) continue;
            String strDestinationFile = this.resolveTextBasedMapping(contentsMap, sourceFile.getPath());
            this.renameFile(sourceFile, new File(strDestinationFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.CONTENT)) {
            return;
        }
        PreparedStatement select = null;
        PreparedStatement update = null;
        Connection con = null;
        String qrySelect = "select pk1, main_data from COURSE_CONTENTS where crsmain_pk1 = ?";
        String qryUpdate = "update COURSE_CONTENTS set main_data = ? where pk1 = ?";
        int trancount = 0;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            select = con.prepareStatement(qrySelect);
            update = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            ResultSet rst = select.executeQuery();
            while (rst.next()) {
                Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                String text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"main_data", null);
                if (text == null || text.length() == 0) continue;
                String replace = text;
                replace = this.resolveTextBasedMapping((Map)this._dbBasedIdMap.get("FILES"), replace);
                if (text.equals(replace)) continue;
                if (this._bbDatabase.isOracle()) {
                    this.updateOracleBasedContentClobs(cId, replace, con);
                } else {
                    DbUtil.setClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                    Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                    update.execute();
                }
                if (++trancount <= cfg.getMaximumTransactionCount()) continue;
                trancount = 0;
                con.commit();
            }
            DbUtil.closeResultSet((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.closeStatement(select);
            DbUtil.closeStatement(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.closeStatement((Statement)select);
        DbUtil.closeStatement((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected CourseToc matchTocByAttributes(CourseToc srcToc, List tgtTocList) {
        for (CourseToc toc : tgtTocList) {
            String tmp;
            if (this.compareString(srcToc.getPersistentLabel(), toc.getPersistentLabel()) && srcToc.getTargetType() == toc.getTargetType() && this.compareString(srcToc.getInternalHandle(), toc.getInternalHandle())) {
                return toc;
            }
            if (this.compareString(srcToc.getPersistentLabel(), toc.getPersistentLabel()) || srcToc.getTargetType() != toc.getTargetType() || !this.compareString(srcToc.getInternalHandle(), toc.getInternalHandle())) continue;
            if (!srcToc.getPersistentLabel().startsWith("COURSE_DEFAULT") && toc.getPersistentLabel().startsWith("COURSE_DEFAULT")) {
                int toc_pos = toc.getPersistentLabel().indexOf(".");
                String toc_sec = toc.getPersistentLabel().substring(toc_pos + 1);
                int toc_pos_sec = toc_sec.indexOf(".");
                String toc_fin = toc_sec.substring(0, toc_pos_sec);
                if (srcToc.getPersistentLabel().contains(toc_fin)) {
                    return toc;
                }
            }
            if (!srcToc.getPersistentLabel().startsWith("COURSE_DEFAULT") || toc.getPersistentLabel().startsWith("COURSE_DEFAULT") || (tmp = srcToc.getPersistentLabel()) == null) continue;
            int srcToc_pos = tmp.indexOf(".");
            String srcToc_sec = tmp.substring(srcToc_pos + 1);
            int srcToc_pos_sec = srcToc_sec.indexOf(".");
            String srcToc_fin = srcToc_sec.substring(0, srcToc_pos_sec);
            if (!toc.getPersistentLabel().contains(srcToc_fin)) continue;
            return toc;
        }
        return null;
    }

    protected boolean compareString(String val1, String val2) {
        if (val1 == null && val2 == null) {
            return true;
        }
        if (val1 != null && val2 != null) {
            return val1.equals(val2);
        }
        return false;
    }

    protected CourseToc matchTocById(Id id, BbList srcTocList) {
        for (CourseToc toc : srcTocList) {
            if (!toc.getId().equals((Object)id)) continue;
            return toc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOracleBasedContentClobs(Id id, String buffer, Connection con) throws Exception {
        PreparedStatement update = null;
        String qryUpdate = "select main_data from COURSE_CONTENTS where pk1 = ? for update of main_data";
        boolean bAutoCommit = con.getAutoCommit();
        try {
            con.setAutoCommit(false);
            update = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)update, (int)1, (Id)id);
            ResultSet rst = update.executeQuery();
            if (rst.next()) {
                DbUtil.setClob((ResultSet)rst, (int)1, (String)buffer);
            }
        }
        catch (Throwable throwable) {
            DbUtil.closeStatement(update);
            con.setAutoCommit(bAutoCommit);
            throw throwable;
        }
        DbUtil.closeStatement((Statement)update);
        con.setAutoCommit(bAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCourseCartridgeId() throws Exception {
        Connection con = null;
        PreparedStatement stmt = null;
        String qryUpdate = "update course_main set cartridge_pk1 = ? where batch_uid = ?";
        if (this._srcSite.getCartridgeId() == null || !this._srcSite.getCartridgeId().isSet()) {
            return;
        }
        if (this._tgtSite.getCartridgeId() != null && this._tgtSite.getCartridgeId().isSet()) {
            return;
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._srcSite.getCartridgeId());
            DbUtil.setNString((PreparedStatement)stmt, (int)2, (String)this._tgtSite.getBatchUid(), (boolean)this._bbDatabase.isOracle());
            stmt.execute();
            this._tgtSite.setCartridgeId(this._srcSite.getCartridgeId());
        }
        catch (Throwable throwable) {
            DbUtil.closeStatement(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private void executeCartridgeCloneProcedure(String procedureName, CloneConfig cfg) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CartridgeCloneQuery.getCloneQuery(procedureName, con);
            CartridgeCloneQuery.marshallParams(this._srcSite, this._tgtSite, this._sessionId, cfg.getMaximumTransactionCount(), cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK), stmt);
            stmt.execute();
            con.commit();
        }
        catch (SQLException sqe) {
            try {
                DbUtil.rollbackConnection((Connection)con);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    static class CartridgeCloneQuery {
        CartridgeCloneQuery() {
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con) throws SQLException {
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, String sessionId, int commitFrequency, boolean bGradebook, CallableStatement stmt) throws SQLException {
            String cartridgeInd = "N";
            if (tgtCourse.getCartridgeId() == null || !tgtCourse.getCartridgeId().isSet() || srcCourse.getCartridgeId().equals((Object)tgtCourse.getCartridgeId())) {
                cartridgeInd = "Y";
            }
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            stmt.setString(3, cartridgeInd);
            stmt.setInt(4, commitFrequency);
            stmt.setString(5, sessionId);
            DbUtil.setString((PreparedStatement)stmt, (int)6, (String)DbUtil.booleanToYN((!bGradebook ? 1 : 0) != 0));
        }
    }
}

