/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.operator.ContentCloneOperator;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.navigation.CourseToc;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.platform.BbServiceManager;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CourseCorrectionCloneOperator
extends ContentCloneOperator {
    public CourseCorrectionCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        if (cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC) || cfg.isAreaIncluded(CloneConfig.Area.ASSESSMENT) || cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK) || cfg.isAreaIncluded(CloneConfig.Area.GRADES)) {
            try {
                PurgeCorruptAsmtQuery query = new PurgeCorruptAsmtQuery(this._tgtSite.getId());
                this._pm.runDbQuery((Query)query, null);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
        if (cfg.getReconcileFlag().booleanValue() && (cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION) || cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC) || cfg.isAreaIncluded(CloneConfig.Area.SETTING))) {
            this.reconcileCourseToc();
        }
    }

    private void reconcileCourseToc() throws Exception {
        CourseTocDbLoader cLoader = CourseTocDbLoader.Default.getInstance();
        BbList srcTocList = cLoader.loadByCourseId(this._srcSite.getId());
        BbList tgtTocList = cLoader.loadByCourseId(this._tgtSite.getId());
        Iterator iter = srcTocList.iterator();
        Map crsTocMap = (Map)this._dbBasedIdMap.get("COURSE_TOC");
        if (crsTocMap == null) {
            return;
        }
        while (iter.hasNext()) {
            CourseToc tgtToc = null;
            CourseToc srcToc = null;
            srcToc = (CourseToc)iter.next();
            String tgtTocId = (String)crsTocMap.get(srcToc.getId().toExternalString());
            if (tgtTocId != null) {
                Id id = BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(CourseToc.DATA_TYPE, tgtTocId);
                tgtToc = this.matchTocById(id, tgtTocList);
            }
            if (tgtToc == null) {
                tgtToc = this.matchTocByAttributes(srcToc, (List)tgtTocList);
            }
            if (tgtToc == null) continue;
            try {
                ReorderCourseTocQuery query = new ReorderCourseTocQuery(tgtToc.getId(), srcToc.getPosition());
                this._pm.runDbQuery((Query)query, null);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private class ReorderCourseTocQuery
    extends StoredProcedureQuery {
        private Id _crsTocId;
        private int _iPosition;

        public ReorderCourseTocQuery(Id crsTocId, int newPosition) {
            super("reposition_course_toc");
            this._crsTocId = null;
            this._iPosition = 0;
            this._crsTocId = crsTocId;
            this._iPosition = newPosition;
            this.addInputParameter("course_toc_pk1");
            this.addInputParameter("new_position");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("course_toc_pk1"), (Id)this._crsTocId);
            DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("new_position"), (int)this._iPosition);
        }
    }

    private class PurgeCorruptAsmtQuery
    extends StoredProcedureQuery {
        private Id _courseId;

        public PurgeCorruptAsmtQuery(Id courseId) {
            super("purge_corrupt_asmt_assignment");
            this._courseId = null;
            this._courseId = courseId;
            this.addInputParameter("crsmain_pk1");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("crsmain_pk1"), (Id)this._courseId);
        }
    }
}

