/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ContentCloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.content.Content;
import blackboard.data.course.Course;
import blackboard.data.navigation.CourseToc;
import blackboard.db.BbDatabase;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.content.ContentDbLoader;
import blackboard.persist.content.ContentDbPersister;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.persist.navigation.CourseTocDbPersister;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CourseTocCloneOperator
extends ContentCloneOperator {
    private ArrayList<Thread> _threadList = new ArrayList();

    public CourseTocCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || !cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC)) {
            return;
        }
        Map tocMap = this.reconcileCourseToc(cfg);
        Set keys = tocMap.keySet();
        for (CourseToc srcToc : keys) {
            CourseToc tgtToc = (CourseToc)tocMap.get(srcToc);
            if (srcToc.getContentId() == null || srcToc.getContentId() == Id.UNSET_ID) continue;
            this.executeCourseTocCloneProcedure(srcToc, tgtToc, cfg);
        }
        this.updateCourseCartridgeId();
        this.handleDirectoryIdMapping();
        this.doCallbackSegment(CloneCallback.Stage.COURSE_TOC, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.coursetoc"), System.currentTimeMillis() - lStart);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || !cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC)) {
            return;
        }
        Iterator<Thread> iter = this._threadList.iterator();
        Exception exc = null;
        while (iter.hasNext()) {
            CloneOperator.AsynchronousDirectoryClone thread = (CloneOperator.AsynchronousDirectoryClone)iter.next();
            thread.join();
            if (exc != null) continue;
            exc = thread.getException();
        }
        if (exc != null) {
            throw exc;
        }
    }

    private void executeCourseTocCloneProcedure(CourseToc srcToc, CourseToc tgtToc, CloneConfig cfg) throws Exception {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            con.setAutoCommit(false);
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("{ call one_course_content_cp");
            sqlStmt.append(" ( ?, ?, ?, ?, ?, ?, ? ) } ");
            stmt = con.prepareCall(sqlStmt.toString());
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._srcSite.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)srcToc.getContentId());
            Bb5Util.setId((PreparedStatement)stmt, (int)3, (Id)this._tgtSite.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)4, (Id)tgtToc.getContentId());
            stmt.setString(5, this._sessionId);
            DbUtil.setString((PreparedStatement)stmt, (int)6, (String)DbUtil.booleanToYN((!cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK) ? 1 : 0) != 0));
            DbUtil.setString((PreparedStatement)stmt, (int)7, (String)DbUtil.booleanToYN((boolean)cfg.isAreaIncluded(CloneConfig.Area.COURSE_CARTRIDGE)));
            stmt.execute();
            con.commit();
        }
        catch (SQLException sqe) {
            try {
                sqe.printStackTrace();
                DbUtil.rollbackConnection((Connection)con);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private Map reconcileCourseToc(CloneConfig cfg) throws Exception {
        HashMap<CourseToc, CourseToc> tocMap = new HashMap<CourseToc, CourseToc>();
        List list = cfg.getCourseTocIdList();
        Iterator iter = list.iterator();
        CourseTocDbLoader cLoader = CourseTocDbLoader.Default.getInstance();
        CourseTocDbPersister cPersister = CourseTocDbPersister.Default.getInstance();
        ContentDbLoader cntLoader = ContentDbLoader.Default.getInstance();
        ContentDbPersister cntPersister = ContentDbPersister.Default.getInstance();
        BbList srcTocList = cLoader.loadByCourseId(this._srcSite.getId());
        BbList tgtTocList = cLoader.loadByCourseId(this._tgtSite.getId());
        while (iter.hasNext()) {
            Id id = BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(CourseToc.DATA_TYPE, (String)iter.next());
            CourseToc tgtToc = null;
            CourseToc srcToc = null;
            srcToc = cfg.getRegisteredCourseToc(id);
            if (srcToc == null) {
                srcToc = this.matchTocById(id, srcTocList);
            }
            if (srcToc == null) {
                throw new PersistenceException(ConfigurationManager.getGlobalLocaleExceptionMessage("clone.coursetoc.noresolve"));
            }
            tgtToc = this.matchTocByAttributes(srcToc, (List)tgtTocList);
            if (tgtToc == null) {
                Content tgtCnt = null;
                Content srcCnt = null;
                if (srcToc.getContentId() != null && srcToc.getContentId() != Id.UNSET_ID) {
                    srcCnt = cntLoader.loadById(srcToc.getContentId());
                    tgtCnt = new Content();
                    tgtCnt.setAllowGuests(srcCnt.getAllowGuests());
                    tgtCnt.setAllowObservers(srcCnt.getAllowObservers());
                    tgtCnt.setBody(srcCnt.getBody());
                    tgtCnt.setContentHandler(srcCnt.getContentHandler());
                    tgtCnt.setEndDate(srcCnt.getEndDate());
                    tgtCnt.setIsAvailable(srcCnt.getIsAvailable());
                    tgtCnt.setIsDescribed(srcCnt.getIsDescribed());
                    tgtCnt.setIsFolder(srcCnt.getIsFolder());
                    tgtCnt.setIsFromCartridge(srcCnt.getIsFromCartridge());
                    tgtCnt.setIsLesson(srcCnt.getIsLesson());
                    tgtCnt.setIsSequential(srcCnt.getIsSequential());
                    tgtCnt.setIsTracked(srcCnt.getIsTracked());
                    tgtCnt.setLaunchInNewWindow(srcCnt.getLaunchInNewWindow());
                    tgtCnt.setOfflineName(srcCnt.getOfflineName());
                    tgtCnt.setOfflinePath(srcCnt.getOfflinePath());
                    tgtCnt.setRenderType(srcCnt.getRenderType());
                    tgtCnt.setTitle(srcCnt.getPersistentTitle());
                    tgtCnt.setTitleColor(srcCnt.getTitleColor());
                    tgtCnt.setUrl(srcCnt.getUrl());
                    tgtCnt.setCourseId(this._tgtSite.getId());
                    tgtCnt.setId(Id.UNSET_ID);
                    cntPersister.persist(tgtCnt);
                }
                tgtToc = new CourseToc();
                tgtToc.setAllowGuests(srcToc.getAllowGuests());
                tgtToc.setAllowObservers(srcToc.getAllowObservers());
                tgtToc.setInternalHandle(srcToc.getInternalHandle());
                tgtToc.setIsEnabled(srcToc.getIsEnabled());
                tgtToc.setIsEntryPoint(srcToc.getIsEntryPoint());
                tgtToc.setLabel(srcToc.getPersistentLabel());
                tgtToc.setLaunchInNewWindow(srcToc.getLaunchInNewWindow());
                tgtToc.setTargetType(srcToc.getTargetType());
                tgtToc.setUrl(srcToc.getUrl());
                tgtToc.setCourseId(this._tgtSite.getId());
                if (tgtCnt != null) {
                    tgtToc.setContentId(tgtCnt.getId());
                }
                tgtToc.setId(Id.UNSET_ID);
                cPersister.persist(tgtToc);
                tgtTocList.add((Object)tgtToc);
            }
            tocMap.put(srcToc, tgtToc);
        }
        return tocMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDirectoryIdMapping() throws Exception {
        PreparedStatement stmt = null;
        Connection con = null;
        ResultSet rst = null;
        File srcPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._srcSite.getCourseId());
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement("select * from tmp_key_maps where session_id = ? and table_name = ? order by table_name desc");
            stmt.setString(1, this._sessionId);
            stmt.setString(2, "COURSE_CONTENTS");
            rst = stmt.executeQuery();
            CloneOperator.AsynchronousDirectoryClone thread = new CloneOperator.AsynchronousDirectoryClone();
            while (rst.next()) {
                Id oldId = Bb5Util.unmarshallId((ResultSet)rst, (String)"old_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                if (oldId == null || newId == null) continue;
                thread.addPaths(new File(srcPath, "content" + File.separator + oldId.toExternalString()), new File(tgtPath, "content" + File.separator + newId.toExternalString()));
                this._threadList.add(thread);
            }
            thread.start();
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rst);
            DbUtil.closeStatement(stmt);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.closeResultSet((ResultSet)rst);
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
        if (cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || !cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC)) {
            return;
        }
        PreparedStatement select = null;
        PreparedStatement update = null;
        Connection con = null;
        String qrySelect = "select pk1, main_data from COURSE_CONTENTS where crsmain_pk1 = ? and pk1 in ( select new_pk1 from tmp_key_maps where session_id = ? and table_name='COURSE_CONTENTS' )";
        String qryUpdate = "update COURSE_CONTENTS set main_data = ? where pk1 = ?";
        int trancount = 0;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            select = con.prepareStatement(qrySelect);
            update = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            select.setString(2, this._sessionId);
            ResultSet rst = select.executeQuery();
            while (rst.next()) {
                Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Course.DATA_TYPE, (Container)this._pm.getContainer());
                String text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"main_data", null);
                if (text == null || text.length() == 0) continue;
                String replace = text;
                replace = this.resolveTextBasedMapping((Map)this._dbBasedIdMap.get("FILES"), replace);
                if (text.equals(replace)) continue;
                if (this._bbDatabase.isOracle()) {
                    this.updateOracleBasedContentClobs(cId, replace, con);
                } else {
                    DbUtil.setClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                    Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                    update.execute();
                }
                if (++trancount <= cfg.getMaximumTransactionCount()) continue;
                trancount = 0;
                con.commit();
            }
            DbUtil.closeResultSet((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.closeStatement(select);
            DbUtil.closeStatement(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.closeStatement((Statement)select);
        DbUtil.closeStatement((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }
}

