/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.operator.CourseTocCloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.data.navigation.CourseToc;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.PersistenceException;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.persist.navigation.CourseTocDbPersister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseTocOrderingOperator
extends CourseTocCloneOperator {
    public CourseTocOrderingOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    @Override
    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        this.processCourseToc(cfg);
    }

    private void processCourseToc(CloneConfig cfg) throws PersistenceException, ValidationException {
        if (cfg.getReconcileFlag().booleanValue()) {
            return;
        }
        CourseTocDbPersister cPersister = CourseTocDbPersister.Default.getInstance();
        BbList tocList = null;
        try {
            tocList = this.updatePositionNumberOfNewTocItems(cfg);
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
        CourseTocPositionComparator courseTocPositionComparator = new CourseTocPositionComparator();
        Collections.sort(tocList, courseTocPositionComparator);
        int tgtTocPos = 0;
        for (CourseToc tgtToc : tocList) {
            tgtToc.setPosition(tgtTocPos);
            cPersister.persist(tgtToc);
            ++tgtTocPos;
        }
    }

    private BbList updatePositionNumberOfNewTocItems(CloneConfig cfg) throws Exception {
        CourseTocDbLoader cLoader = CourseTocDbLoader.Default.getInstance();
        BbList sourceTocList = cLoader.loadByCourseId(this._srcSite.getId());
        BbList targetTocListUpdated = cLoader.loadByCourseId(this._tgtSite.getId());
        ArrayList targetTocListOriginal = cfg.getOriginalTargetCourseTocList();
        List newTocItemsList = this.getNewCourseTocList(targetTocListOriginal, (List)targetTocListUpdated);
        Iterator iter = newTocItemsList.iterator();
        while (iter.hasNext()) {
            CourseToc newToc = null;
            CourseToc srcToc = null;
            newToc = (CourseToc)iter.next();
            srcToc = this.matchTocByAttributes(newToc, (List)sourceTocList);
            if (null == srcToc) {
                throw new PersistenceException(ConfigurationManager.getGlobalLocaleExceptionMessage("clone.coursetoc.noresolve"));
            }
            CourseToc tgtToc = this.matchTocByAttributes(srcToc, (List)targetTocListUpdated);
            if (null == tgtToc) {
                throw new PersistenceException(ConfigurationManager.getGlobalLocaleExceptionMessage("clone.coursetoc.noresolve"));
            }
            tgtToc.setPosition(targetTocListUpdated.size() + srcToc.getPosition());
        }
        this.reLabelCourseToc((List)targetTocListUpdated);
        return targetTocListUpdated;
    }

    private List getNewCourseTocList(List originalList, List updatedList) {
        ArrayList<CourseToc> newTocItemsList = new ArrayList<CourseToc>();
        if (originalList.size() < updatedList.size()) {
            for (CourseToc updatedToc : updatedList) {
                if (null != this.matchTocByAttributes(updatedToc, originalList)) continue;
                newTocItemsList.add(updatedToc);
            }
        }
        return newTocItemsList;
    }

    private void reLabelCourseToc(List list) throws Exception {
        Iterator<Object> iter = list.iterator();
        HashMap<String, CourseToc> labelMap = new HashMap<String, CourseToc>();
        HashMap<String, CourseToc> collisions = new HashMap<String, CourseToc>();
        while (iter.hasNext()) {
            CourseToc aToc;
            CourseToc cToc = (CourseToc)iter.next();
            String persistentLabel = cToc.getPersistentLabel();
            int idx = persistentLabel.indexOf(":");
            if (idx >= 0) {
                persistentLabel = persistentLabel.substring(0, idx).trim();
                cToc.setLabel(persistentLabel);
            }
            if ((aToc = (CourseToc)labelMap.get(persistentLabel)) != null) {
                collisions.put(cToc.getId().toExternalString(), cToc);
                continue;
            }
            labelMap.put(persistentLabel, cToc);
        }
        if (collisions.isEmpty()) {
            return;
        }
        for (CourseToc cToc : collisions.values()) {
            this.renameCourseToc(labelMap, cToc, 1);
        }
    }

    private void renameCourseToc(Map<String, CourseToc> labelMap, CourseToc cToc, int posLabel) throws Exception {
        String tocLabel = cToc.getPersistentLabel() + posLabel;
        if (!labelMap.containsKey(tocLabel)) {
            cToc.setLabel(tocLabel);
            labelMap.put(tocLabel, cToc);
            CourseTocDbPersister persister = CourseTocDbPersister.Default.getInstance();
            persister.persist(cToc);
        } else {
            this.renameCourseToc(labelMap, cToc, posLabel + 1);
        }
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CourseTocPositionComparator
    implements Comparator<CourseToc> {
        private CourseTocPositionComparator() {
        }

        @Override
        public int compare(CourseToc o1, CourseToc o2) {
            CourseToc ct2;
            int pos2;
            CourseToc ct1 = o1;
            int pos1 = ct1.getPosition();
            if (pos1 < (pos2 = (ct2 = o2).getPosition())) {
                return -1;
            }
            if (pos1 == pos2) {
                return 0;
            }
            return 1;
        }
    }
}

