/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import java.io.File;
import java.util.Map;

public class DiscussionBoardCloneOperator
extends CloneOperator {
    public DiscussionBoardCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.DISCUSSION_BOARD)) {
            return;
        }
        this.executeCloneProcedure("course_conference_main_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_forum_main_cp", cfg.getMaximumTransactionCount());
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
            String flag = "N";
            if (cfg.isAreaIncluded(CloneConfig.Area.DISCUSSION_CARTRIDGE)) {
                flag = "Y";
            }
            this.executeCloneProcedure("course_msg_main_cp", cfg.getMaximumTransactionCount(), flag);
            this.executeCloneProcedure("course_msg_attachment_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("user_forum_settings_c_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("user_msg_state_c_cp", cfg.getMaximumTransactionCount());
        } else {
            this.executeCloneProcedure("course_msg_main_seed_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("course_msg_attachment_seed_cp", cfg.getMaximumTransactionCount());
        }
        if (cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
            this.executeCloneProcedure("group_conference_main_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("group_forum_main_cp", cfg.getMaximumTransactionCount());
            if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
                this.executeCloneProcedure("group_msg_main_cp", cfg.getMaximumTransactionCount());
                this.executeCloneProcedure("group_msg_attachment_cp", cfg.getMaximumTransactionCount());
                this.executeCloneProcedure("user_forum_settings_g_cp", cfg.getMaximumTransactionCount());
                this.executeCloneProcedure("user_msg_state_g_cp", cfg.getMaximumTransactionCount());
            } else {
                this.executeCloneProcedure("group_msg_main_seed_cp", cfg.getMaximumTransactionCount());
                this.executeCloneProcedure("group_msg_attachment_seed_cp", cfg.getMaximumTransactionCount());
            }
        }
        this.doCallbackSegment(CloneCallback.Stage.DISCUSSION_BOARD, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.discussionboard"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        Map tmp = null;
        tmp = (Map)this._dbBasedIdMap.get("MSG_MAIN");
        return this.resolveTextBasedMapping(tmp, dir);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.DISCUSSION_BOARD)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "db");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

