/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import blackboard.util.FileUtil;
import java.io.File;
import java.util.Map;

public class DropBoxCloneOperator
extends CloneOperator {
    public DropBoxCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
            return;
        }
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("files_cuu_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("course_user_uploads_cp", cfg.getMaximumTransactionCount());
        }
        if (cfg.isAreaIncluded(CloneConfig.Area.GROUP) && cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("files_gu_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("group_uploads_cp", cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.DROP_BOX, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.dropbox"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        Map tmp = null;
        tmp = (Map)this._dbBasedIdMap.get("FILES");
        return this.resolveTextBasedMapping(tmp, dir);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.DROP_BOX)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        File sourceDir = new File(tgtPath.getAbsolutePath());
        tgtPath = new File(tgtPath, "uploads");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
        Map groupsMap = (Map)this._dbBasedIdMap.get("GROUPS");
        Map fileMap = (Map)this._dbBasedIdMap.get("FILES");
        sourceDir = new File(sourceDir, "groups");
        String[] fileListing = FileUtil.getDirectoryListing((File)sourceDir);
        if (fileListing == null || fileListing.length == 0) {
            return;
        }
        for (int i = 0; i < fileListing.length; ++i) {
            File sourceFile = new File(fileListing[i]);
            if (sourceFile.isFile()) continue;
            String strDestinationFile = this.resolveTextBasedMapping(groupsMap, sourceFile.getPath());
            File groupDirectory = new File(strDestinationFile);
            this.renameFile(sourceFile, groupDirectory);
            String[] subListing = FileUtil.getDirectoryListing((File)new File(strDestinationFile));
            for (int cnt = 0; cnt < subListing.length; ++cnt) {
                File subFile = new File(subListing[cnt]);
                if (!subFile.isDirectory()) continue;
                String childDirectory = subFile.getName();
                childDirectory = this.resolveTextBasedMapping(fileMap, childDirectory);
                this.renameFile(subFile, new File(groupDirectory, childDirectory));
            }
        }
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

