/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import blackboard.util.FileUtil;
import java.io.File;
import java.util.Map;

public class GlossaryCloneOperator
extends CloneOperator {
    public static String GLOSSARY_PROPERTIES = "glossary.properties";
    public static String GLOSSARY_HTML = "glossary_r7.html";
    public static String GLOSSARY_CSV = "glossary_export.xls";
    public static String GLOSSARY_PANEL = "gloss_panel.html";

    public GlossaryCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.GLOSSARY)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        FileUtil.delete((File)new File(tgtPath, GLOSSARY_CSV));
        FileUtil.delete((File)new File(tgtPath, GLOSSARY_HTML));
        FileUtil.delete((File)new File(tgtPath, GLOSSARY_PANEL));
        this.doCallbackSegment(CloneCallback.Stage.GLOSSARY, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.glossary"), System.currentTimeMillis() - lStart);
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

