/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Id;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class GradebookCloneOperator
extends CloneOperator {
    public GradebookCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
            return;
        }
        this.executeGradebookProcedure("cleanup_dst_gradebook");
        this.executeCloneProcedure("gradebook_settings_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gradebook_type_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gradebook_translator_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gradebook_symbol_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("gradebook_main_cp", cfg.getMaximumTransactionCount());
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP) && cfg.isAreaIncluded(CloneConfig.Area.GRADES)) {
            this.executeCloneProcedure("gradebook_grade_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("qti_result_data_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("attempt_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("update_gradebook_grade_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("files_af_cp", cfg.getMaximumTransactionCount());
            this.executeCloneProcedure("attempt_files_cp", cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.GRADEBOOK, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.gradebook"), System.currentTimeMillis() - lStart);
    }

    private void executeGradebookProcedure(String procedureName) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareCall("{ call " + procedureName + " ( ? ) } ");
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._tgtSite.getId());
            stmt.execute();
            con.commit();
        }
        catch (SQLException sqe) {
            try {
                DbUtil.rollbackConnection((Connection)con);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    public String getDirectoryTranslation(String dir) {
        Map tmp = null;
        tmp = (Map)this._dbBasedIdMap.get("ATTEMPT");
        return this.resolveTextBasedMapping(tmp, dir);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        this.doDirectoryPathTranslation(new File(tgtPath, "gradebook").getAbsolutePath());
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP) && cfg.isAreaIncluded(CloneConfig.Area.GRADES)) {
            this.doDirectoryPathTranslation(new File(tgtPath, "attempt").getAbsolutePath());
        }
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

