/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.data.course.Course;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Id;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class MembershipCloneOperator
extends CloneOperator {
    public MembershipCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            return;
        }
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
            this.executeMembershipCloneProcedure("course_users_exact_cp", cfg.getMembershipDataSourceId(), cfg.getMaximumTransactionCount());
        } else {
            this.executeMembershipCloneProcedure("course_users_cp", cfg.getMembershipDataSourceId(), cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.MEMBERSHIP, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.membership"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        Map tmp = null;
        tmp = (Map)this._dbBasedIdMap.get("COURSE_USERS");
        return this.resolveTextBasedMapping(tmp, dir);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "uploads" + File.separator + "homepage");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }

    private void executeMembershipCloneProcedure(String procedureName, Id membershipDataSourceId, int commitFrequency) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = MembershipCloneQuery.getCloneQuery(procedureName, con);
            MembershipCloneQuery.marshallParams(this._srcSite, this._tgtSite, membershipDataSourceId, this._sessionId, commitFrequency, stmt);
            stmt.execute();
            con.commit();
        }
        catch (SQLException sqe) {
            try {
                DbUtil.rollbackConnection((Connection)con);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    static class MembershipCloneQuery {
        MembershipCloneQuery() {
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con) throws SQLException {
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, Id membershipDataSourceId, String sessionId, int commitFrequency, CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)3, (Id)membershipDataSourceId);
            stmt.setInt(4, commitFrequency);
            stmt.setString(5, sessionId);
        }
    }
}

