/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.navigation.CourseNavigationApplicationDbPersister;
import blackboard.persist.navigation.CourseTocDbPersister;
import java.util.Map;

public class ReconciliationCloneOperator
extends CloneOperator {
    public ReconciliationCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.getReconcileFlag().booleanValue()) {
            return;
        }
        this.removeAllPointsOfReconciliation();
        this.doCallbackSegment(CloneCallback.Stage.RECONCILIATION, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.reconciliation"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }

    private void removeAllPointsOfReconciliation() throws Exception {
        CourseNavigationApplicationDbPersister nPersister = CourseNavigationApplicationDbPersister.Default.getInstance();
        nPersister.deleteByCourseId(this._tgtSite.getId());
        CourseTocDbPersister cPersister = CourseTocDbPersister.Default.getInstance();
        cPersister.deleteByCourseId(this._tgtSite.getId());
    }
}

