/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.data.course.Course;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.course.CourseDbPersister;
import java.util.Map;

public class SettingCloneOperator
extends CloneOperator {
    public SettingCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.SETTING)) {
            return;
        }
        this.executeCloneProcedure("course_navigation_item_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_application_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_content_handlers_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_toc_settings_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_registry_cp", cfg.getMaximumTransactionCount());
        this.duplicateSettings(this._srcSite, this._tgtSite);
        this.doCallbackSegment(CloneCallback.Stage.SETTING, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.settings"), System.currentTimeMillis() - lStart);
    }

    private void duplicateSettings(Course srcSite, Course tgtSite) throws Exception {
        CourseDbPersister persister = CourseDbPersister.Default.getInstance();
        tgtSite.setButtonStyleId(srcSite.getButtonStyleId());
        tgtSite.setNavStyle(srcSite.getNavStyle());
        tgtSite.setNavColorFg(srcSite.getNavColorFg());
        tgtSite.setNavColorBg(srcSite.getNavColorBg());
        tgtSite.setIsNavCollapsible(srcSite.getIsNavCollapsible());
        tgtSite.setBannerImageFile(srcSite.getBannerImageFile());
        tgtSite.setIsLocaleEnforced(srcSite.getIsLocaleEnforced());
        tgtSite.setLocale(srcSite.getLocale());
        persister.persist(tgtSite);
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

