/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.platform.BbServiceManager;
import blackboard.platform.filesystem.FileSystemService;
import java.io.File;
import java.util.Map;

public class StaffInformationCloneOperator
extends CloneOperator {
    public StaffInformationCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION)) {
            return;
        }
        this.executeCloneProcedure("staffinformation_cp", cfg.getMaximumTransactionCount());
        this.executeCloneProcedure("course_toc_staff_cp", cfg.getMaximumTransactionCount());
        this.doCallbackSegment(CloneCallback.Stage.STAFF_INFORMATION, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.staff"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        Map tmp = null;
        tmp = (Map)this._dbBasedIdMap.get("STAFFINFORMATION");
        return this.resolveTextBasedMapping(tmp, dir);
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
        if (!cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION)) {
            return;
        }
        File tgtPath = ((FileSystemService)BbServiceManager.safeLookupService(FileSystemService.class)).getCourseDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "staffinformation");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

