/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.AppVersion;
import blackboard.persist.BbPersistenceManager;
import blackboard.platform.BbServiceManager;
import blackboard.platform.log.LogService;
import java.util.Map;

public class TaskCloneOperator
extends CloneOperator {
    public TaskCloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map dbBasedIdMap) {
        super(pm, appVersion, dbBasedIdMap);
    }

    public void doDatabaseTranslation(CloneConfig cfg) throws Exception {
        BbServiceManager.getLogService().log("TaskCloneOperator.doDatabaseTranslation()", LogService.Verbosity.DEBUG);
        long lStart = System.currentTimeMillis();
        if (!cfg.isAreaIncluded(CloneConfig.Area.TASK)) {
            return;
        }
        this.executeCloneProcedure("tasks_cp", cfg.getMaximumTransactionCount());
        if (cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("tasks_users_cp", cfg.getMaximumTransactionCount());
        }
        this.doCallbackSegment(CloneCallback.Stage.TASK, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.task"), System.currentTimeMillis() - lStart);
    }

    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    public void doContentDirectoryTranslation(CloneConfig cfg) throws Exception {
    }

    public void doEmbeddedDatabaseIdTranslation(CloneConfig cfg) throws Exception {
    }
}

