/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.soap.admincourse;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.AdminCourseXmlPersisterImpl;
import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.base.BbList;
import blackboard.persist.PersistenceException;
import blackboard.platform.BbServiceManager;
import blackboard.util.ObjectSerializer;
import blackboard.xml.XmlUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientUtility
implements IClientUtility {
    private static final String SOAP_URN = "CourseServerUtility";
    private static final String SAVE = "save";
    private static final String INSERT = "insert";
    private static final String UPDATE = "update";
    private static final String REMOVE = "remove";
    private static final String REMOVE_LIST = "removeList";
    private static final String CREATE_SESSION = "createSession";
    private static final String CLOSE_SESSION = "closeSession";
    private static final String LOAD = "load";
    private static final String LOAD_BY_TEMPLATE = "loadByTemplate";
    private static final String CLONE = "clone";
    private String _sMethod;
    private Vector<String> _vArgs = new Vector();

    public String getObjectNameSpace() {
        return SOAP_URN;
    }

    public String getMethodName() {
        return this._sMethod;
    }

    public Vector getArguments() {
        return this._vArgs;
    }

    public void createSession(String dataSourceBatchUid) {
        this._sMethod = CREATE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
    }

    public void createSession(String dataSourceBatchUid, String session) {
        this._sMethod = CREATE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        this._vArgs.add(session);
    }

    public void closeSession(String strSessionId) {
        this._sMethod = CLOSE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(strSessionId);
    }

    public void load(String batchUid) {
        this._sMethod = LOAD;
        this._vArgs.removeAllElements();
        this._vArgs.add(batchUid);
    }

    public void load(AdminCourse template) throws PersistenceException {
        this._sMethod = LOAD_BY_TEMPLATE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(template));
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString((AdminCourse)obj));
        this._vArgs.add(strSessionId);
    }

    public void save(BbList objList, String strSessionId) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objList));
        this._vArgs.add(strSessionId);
        this._vArgs.add(ObjectSerializer.serializeObject((Object)Authority.getSettings()));
    }

    public void remove(BbList objList) throws PersistenceException {
        this._sMethod = REMOVE_LIST;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objList));
    }

    public void save(AdminCourse objToSave) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objToSave));
    }

    public void save(AdminCourse objToSave, String strSessionId) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objToSave));
        this._vArgs.add(strSessionId);
    }

    public void insert(AdminCourse objToSave) throws PersistenceException {
        this._sMethod = INSERT;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objToSave));
    }

    public void update(AdminCourse objToSave) throws PersistenceException {
        this._sMethod = UPDATE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objToSave));
    }

    public void remove(AdminCourse objToRemove) throws PersistenceException {
        this._sMethod = REMOVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(objToRemove));
    }

    public void clone(String srcCrsBatchUid, String tgtCrsBatchUid, CloneConfig cfg) throws PersistenceException {
        this._sMethod = CLONE;
        this._vArgs.removeAllElements();
        this._vArgs.add(srcCrsBatchUid);
        this._vArgs.add(tgtCrsBatchUid);
        this._vArgs.add(ObjectSerializer.serializeObject((Object)cfg));
    }

    protected static String convertToString(AdminCourse obj) throws PersistenceException {
        Document doc;
        AdminCourseXmlPersisterImpl persist = (AdminCourseXmlPersisterImpl)BbServiceManager.getPersistenceService().getXmlPersistenceManager().getPersister("CourseSiteXmlPersister");
        try {
            doc = XmlUtil.buildDocument();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        Element element = persist.persist(obj, doc);
        doc.appendChild(element);
        String tmp = null;
        try {
            tmp = XmlUtil.createEncodedStringFromDoc((Document)doc, (boolean)false, (String)"UTF-8");
        }
        catch (IOException io) {
            throw new PersistenceException((Throwable)io);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        return tmp;
    }

    protected static String convertToString(BbList list) throws PersistenceException {
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        sb.append("<enterprise>");
        while (iter.hasNext()) {
            sb.append(ClientUtility.convertToString((AdminCourse)iter.next()));
        }
        sb.append("</enterprise>");
        return sb.toString();
    }
}

