/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.soap.admincourse;

import blackboard.admin.data.course.CourseSite;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.impl.soap.admincourse.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.platform.BbServiceManager;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "admincourse.id.list";

    public static void clone(String srcCrsBatchUid, String tgtCrsBatchUid, String strCfg) throws PersistenceException, ValidationException, ConstraintViolationException {
        CloneConfig cfg = (CloneConfig)ObjectSerializer.deSerializeObject((String)strCfg);
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        p.clone(srcCrsBatchUid, tgtCrsBatchUid, cfg);
    }

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        BbList list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (CourseSite tmp : list) {
            p.insert(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        BbList list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (CourseSite tmp : list) {
            p.update(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        BbList list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        for (CourseSite tmp : list) {
            p.save(tmp);
            aList.add(tmp.getId().toExternalString());
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException, ConnectionNotAvailableException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        BbList list = ServerUtility.unMarshallObjects(props, obj, CourseSite.DATA_TYPE);
        Results results = Authority.delegateAdminCoursePersistence(list, p, session, null);
        Iterator iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            CourseSite tmp = (CourseSite)iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        BbList list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        CourseSite cSite = (CourseSite)list.get(0);
        p.remove(cSite);
    }

    public static String removeList(String obj) throws PersistenceException, ValidationException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        BbList list = ServerUtility.unMarshallObjects(obj, CourseSite.DATA_TYPE);
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid) throws PersistenceException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        return p.createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        p.createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId) throws PersistenceException {
        CourseSitePersister p = (CourseSitePersister)ServerUtility.getPersister();
        p.closeSession(strSessionId);
    }

    public static String load(String batchUid) throws PersistenceException, KeyNotFoundException {
        CourseSiteLoader l = (CourseSiteLoader)ServerUtility.getLoader();
        CourseSite obj = l.load(batchUid);
        return ClientUtility.convertToString(obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        CourseSiteLoader l = (CourseSiteLoader)ServerUtility.getLoader();
        BbList list = ServerUtility.unMarshallObjects(template, CourseSite.DATA_TYPE);
        if (list.size() == 0) {
            return "";
        }
        list = l.load((CourseSite)list.get(0));
        return ClientUtility.convertToString(list);
    }

    private static Persister getPersister() throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("CourseSitePersister");
    }

    private static Loader getLoader() throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("CourseSiteLoader");
    }

    public static BbList unMarshallObjects(String src, DataType dType) throws PersistenceException {
        return ServerUtility.unMarshallObjects(new Properties(), src, dType);
    }

    public static BbList unMarshallObjects(Properties props, String src, DataType dType) throws PersistenceException {
        try {
            props.setProperty("DATA_TYPE_TOGGLE", dType.getName());
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

