/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.datasource.DataSourceObjectCount;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.impl.mapping.DataSourceDbMap;
import blackboard.admin.persist.impl.AdminNewBaseDbLoader;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.SelectQuery;
import blackboard.persist.impl.SimpleSelectQuery;
import blackboard.persist.impl.mapping.DbMapping;
import blackboard.platform.RuntimeBbServiceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DataSourceDbLoader
extends AdminNewBaseDbLoader
implements DataSourceLoader {
    private static final String GROUP = "course_main";
    private static final String MEMBERSHIP = "course_users";
    private static final String PERSON = "users";
    private static final String COURSE_CATEGORIES = "gateway_categories";
    private static final String ORGANIZATION_CATEGORIES = "community_categories";
    private static final String COURSE_CATEGORY_MEMBERSHIP = "gateway_course_categories";
    private static final String ORGANIZATION_CATEGORY_MEMBERSHIP = "community_course_categories";
    private static final String PORTAL_ROLE_MEMBERSHIP = "user_roles";
    private static final String OBSERVER_ASSOCIATION = "observer_user";
    private static final String COURSE_COURSE = "course_course";

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            try {
                super.init(pm, appVersion);
            }
            catch (RuntimeBbServiceException exc) {
                if (!this._lMgr.isLicensed("integration.apis")) break block2;
                throw exc;
            }
        }
    }

    public DataSource loadByBatchUid(String batchUid) throws PersistenceException {
        SimpleSelectQuery query = new SimpleSelectQuery(DataSourceDbMap.MAP);
        query.addWhere("BatchUid", (Object)batchUid);
        return (DataSource)super.loadObject((SelectQuery)query, null);
    }

    public BbList loadAll() throws PersistenceException {
        super.checkApiLicensing();
        SimpleSelectQuery query = new SimpleSelectQuery(DataSourceDbMap.MAP);
        return (BbList)super.loadList((SelectQuery)query, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSourceObjectCount loadAdminObjectCount(String dataSourceBatchUid, DataType dataType, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        DataSourceObjectCount dCount;
        super.checkApiLicensing();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rst = null;
        String tableName = DataSourceDbLoader.getDbTableName(dataType);
        DataSource ds = this.loadByBatchUid(dataSourceBatchUid);
        String query = "select count(pk1) from " + tableName + " where data_src_pk1 = ? ";
        if (status != null) {
            query = query + "and row_status = ?";
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)ds.getId());
            if (status != null) {
                DbMapping map = DataSourceDbMap.MAP.getMapping("RowStatus");
                map.marshall(this._pm.getContainer(), stmt, 2, (Object)status);
            }
            rst = stmt.executeQuery();
            dCount = this.unmarshall(rst, tableName);
        }
        catch (SQLException sqe) {
            try {
                throw new PersistenceException((Throwable)sqe);
                catch (ConnectionNotAvailableException cna) {
                    throw new PersistenceException((Throwable)cna);
                }
            }
            catch (Throwable throwable) {
                DbUtil.closeResultSet(rst);
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeResultSet((ResultSet)rst);
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
        return dCount;
    }

    protected static String getDbTableName(DataType dataType) throws KeyNotFoundException {
        if (dataType.equals((Object)CourseSite.DATA_TYPE)) {
            return GROUP;
        }
        if (dataType.equals((Object)Organization.DATA_TYPE)) {
            return GROUP;
        }
        if (dataType.equals((Object)OrganizationMembership.DATA_TYPE)) {
            return MEMBERSHIP;
        }
        if (dataType.equals((Object)Enrollment.DATA_TYPE)) {
            return MEMBERSHIP;
        }
        if (dataType.equals((Object)StaffAssignment.DATA_TYPE)) {
            return MEMBERSHIP;
        }
        if (dataType.equals((Object)Person.DATA_TYPE)) {
            return PERSON;
        }
        if (dataType.equals((Object)CourseCategory.DATA_TYPE)) {
            return COURSE_CATEGORIES;
        }
        if (dataType.equals((Object)OrganizationCategory.DATA_TYPE)) {
            return ORGANIZATION_CATEGORIES;
        }
        if (dataType.equals((Object)CourseCategoryMembership.DATA_TYPE)) {
            return COURSE_CATEGORY_MEMBERSHIP;
        }
        if (dataType.equals((Object)OrganizationCategoryMembership.DATA_TYPE)) {
            return ORGANIZATION_CATEGORY_MEMBERSHIP;
        }
        if (dataType.equals((Object)PortalRoleMembership.DATA_TYPE)) {
            return PORTAL_ROLE_MEMBERSHIP;
        }
        if (dataType.equals((Object)ObserverAssociation.DATA_TYPE)) {
            return OBSERVER_ASSOCIATION;
        }
        if (dataType.equals((Object)AdminCourseCourse.DATA_TYPE)) {
            return COURSE_COURSE;
        }
        throw new KeyNotFoundException("Data type not recognized");
    }

    public BbList loadAllAdminObjectCounts(String dataSourceBatchUid, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        DataType[] objectTypeList = new DataType[]{CourseSite.DATA_TYPE, Enrollment.DATA_TYPE, CourseCategory.DATA_TYPE, CourseCategoryMembership.DATA_TYPE, OrganizationCategory.DATA_TYPE, OrganizationCategoryMembership.DATA_TYPE, Person.DATA_TYPE, ObserverAssociation.DATA_TYPE, PortalRoleMembership.DATA_TYPE, AdminCourseCourse.DATA_TYPE};
        BbList list = new BbList();
        for (int cnt = 0; cnt < objectTypeList.length; ++cnt) {
            list.add((Object)this.loadAdminObjectCount(dataSourceBatchUid, objectTypeList[cnt], status));
        }
        return list;
    }

    private DataSourceObjectCount unmarshall(ResultSet rst, String tableName) throws SQLException {
        DataSourceObjectCount dCount = new DataSourceObjectCount();
        if (rst.next()) {
            dCount.setObjectCount(rst.getLong(1));
            dCount.setObjectDataTable(tableName);
        }
        return dCount;
    }
}

