/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryLoaderDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryMembershipLoaderDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryLoaderDbMap;
import blackboard.admin.persist.category.impl.mapping.OrganizationCategoryMembershipLoaderDbMap;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.impl.mapping.AdminCourseCourseLoaderDbMap;
import blackboard.admin.persist.course.impl.mapping.EnrollmentDbMap;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.DataSourcePersister;
import blackboard.admin.persist.datasource.impl.AdminDeleteProcedureQuery;
import blackboard.admin.persist.datasource.impl.DataSourceDbLoader;
import blackboard.admin.persist.datasource.impl.mapping.DataSourceDbMap;
import blackboard.admin.persist.role.impl.mapping.PortalRoleMembershipLoaderDbMap;
import blackboard.admin.persist.user.impl.mapping.ObserverAssociationLoaderDbMap;
import blackboard.admin.persist.user.impl.mapping.PersonLoaderDbMap;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.NewBaseDbPersister;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.mapping.DbMapping;
import blackboard.platform.BbServiceManager;
import blackboard.platform.LicenseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;

public class DataSourceDbPersister
extends NewBaseDbPersister
implements DataSourcePersister {
    protected LicenseManager _lMgr;

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        super.init(pm, appVersion);
        this._lMgr = BbServiceManager.getLicenseManager();
        this.checkApiLicensing();
    }

    protected void checkApiLicensing() {
        this._lMgr.runtimeAssertIsLicensed("integration.apis");
    }

    public void create(DataSource target) throws PersistenceException, ValidationException {
        super.doPersist(DataSourceDbMap.MAP, (Object)target, null);
    }

    public void modify(DataSource target) throws PersistenceException, ValidationException, KeyNotFoundException {
        target.validate();
        DataSourceLoader dLoader = (DataSourceLoader)this._pm.getLoader("DataSourceLoader");
        DataSource ds = dLoader.loadByBatchUid(target.getBatchUid());
        Connection con = null;
        PreparedStatement stmt = null;
        String query = "update data_source set batch_uid=?, description=? where batch_uid = ?";
        if (target.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            ds.setBatchUid(target.getReplacementBatchUid());
        }
        if (target.getBbAttributes().getBbAttribute("Description").getIsDirty()) {
            ds.setDescription(target.getDescription());
        } else {
            target.setDescription(ds.getDescription());
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            DbUtil.setNString((PreparedStatement)stmt, (int)1, (String)ds.getBatchUid(), (boolean)this._bbDatabase.isOracle());
            DbUtil.setNString((PreparedStatement)stmt, (int)2, (String)ds.getDescription(), (boolean)this._bbDatabase.isOracle());
            DbUtil.setNString((PreparedStatement)stmt, (int)3, (String)target.getBatchUid(), (boolean)this._bbDatabase.isOracle());
            stmt.executeUpdate();
        }
        catch (Exception sqe) {
            try {
                throw new PersistenceException((Throwable)sqe);
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeByBatchUid(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        Connection con = null;
        PreparedStatement stmt = null;
        String query = "delete from data_source where batch_uid = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            DbUtil.setNString((PreparedStatement)stmt, (int)1, (String)dataSourceBatchUid, (boolean)this._bbDatabase.isOracle());
            int rowsDeleted = stmt.executeUpdate();
            if (rowsDeleted == 0) {
                throw new KeyNotFoundException("Data source not found for : " + dataSourceBatchUid);
            }
        }
        catch (KeyNotFoundException knf) {
            try {
                throw knf;
                catch (Exception sqe) {
                    throw new PersistenceException((Throwable)sqe);
                }
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    public void disableAllAdminObjects(String dataSrcBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        DataType[] objectTypeList = new DataType[]{CourseSite.DATA_TYPE, Enrollment.DATA_TYPE, CourseCategory.DATA_TYPE, CourseCategoryMembership.DATA_TYPE, OrganizationCategory.DATA_TYPE, OrganizationCategoryMembership.DATA_TYPE, Person.DATA_TYPE, ObserverAssociation.DATA_TYPE, PortalRoleMembership.DATA_TYPE, AdminCourseCourse.DATA_TYPE};
        for (int cnt = 0; cnt < objectTypeList.length; ++cnt) {
            this.disableAdminObjectsByDataType(dataSrcBatchUid, objectTypeList[cnt], cal);
        }
    }

    public void disableAdminObjectsByDataType(String dataSrcBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        Connection con = null;
        PreparedStatement stmt = null;
        String tableName = DataSourceDbLoader.getDbTableName(dataType);
        DataSourceLoader dLoader = (DataSourceLoader)this._pm.getLoader("DataSourceLoader");
        DataSource ds = dLoader.loadByBatchUid(dataSrcBatchUid);
        String query = "update " + tableName + " set row_status = ? where data_src_pk1 = ? ";
        if (cal != null) {
            query = query + "and dtmodified < ?";
        }
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.prepareStatement(query);
            DbMapping map = DataSourceDbMap.MAP.getMapping("RowStatus");
            map.marshall(this._pm.getContainer(), stmt, 1, (Object)IAdminObject.RowStatus.DISABLED);
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)ds.getId());
            if (cal != null) {
                stmt.setTimestamp(3, TimeFormat.calendarToTimestamp(cal));
            }
            stmt.executeUpdate();
        }
        catch (Exception sqe) {
            try {
                throw new PersistenceException((Throwable)sqe);
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    public void purgeAllAdminObjects(String dataSrcBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        DataType[] objectTypeList = new DataType[]{CourseSite.DATA_TYPE, Enrollment.DATA_TYPE, CourseCategory.DATA_TYPE, CourseCategoryMembership.DATA_TYPE, OrganizationCategory.DATA_TYPE, OrganizationCategoryMembership.DATA_TYPE, Person.DATA_TYPE, ObserverAssociation.DATA_TYPE, PortalRoleMembership.DATA_TYPE, AdminCourseCourse.DATA_TYPE};
        for (int cnt = 0; cnt < objectTypeList.length; ++cnt) {
            this.purgeAdminObjectsByDataType(dataSrcBatchUid, objectTypeList[cnt], cal);
        }
    }

    public void purgeAdminObjectsByDataType(String dataSrcBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        AdminDeleteProcedureQuery query = null;
        if (dataType.equals((Object)Person.DATA_TYPE)) {
            query = new AdminDeleteProcedureQuery(PersonLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
            query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
            query.addParameter("modifiedDate", cal);
            query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
        } else {
            if (dataType.equals((Object)CourseSite.DATA_TYPE) || dataType.equals((Object)Organization.DATA_TYPE)) {
                this.purgeCoursesByDataSourceBatchUid(dataSrcBatchUid, cal);
                return;
            }
            if (dataType.equals((Object)Enrollment.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(EnrollmentDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)StaffAssignment.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(EnrollmentDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)OrganizationMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(EnrollmentDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)CourseCategory.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(CourseCategoryLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)OrganizationCategory.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(OrganizationCategoryLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)CourseCategoryMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(CourseCategoryMembershipLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)OrganizationCategoryMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(OrganizationCategoryMembershipLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)PortalRoleMembership.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(PortalRoleMembershipLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)ObserverAssociation.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(ObserverAssociationLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else if (dataType.equals((Object)AdminCourseCourse.DATA_TYPE)) {
                query = new AdminDeleteProcedureQuery(AdminCourseCourseLoaderDbMap.MAP, DataSourceDbLoader.getDbTableName(dataType));
                query.addParameter("DataSourceBatchUid", dataSrcBatchUid);
                query.addParameter("modifiedDate", cal);
                query.addParameter("RowStatus", (Object)IAdminObject.RowStatus.DISABLED);
            } else {
                throw new KeyNotFoundException("Data type not recognized.");
            }
        }
        super.runQuery((Query)query, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void purgeSnapshotSessions() throws PersistenceException {
        String[] tableNames = new String[]{"tmp_key_maps", "tmp_cc_keys", "tmp_course_keys", "tmp_cu_keys", "tmp_gc_keys", "tmp_obs_user_keys", "tmp_gcc_keys", "tmp_user_keys", "tmp_ccc_badpk1", "tmp_userrole_keys"};
        Connection con = null;
        Statement stmt = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = con.createStatement();
            for (int cnt = 0; cnt < tableNames.length; ++cnt) {
                stmt.executeUpdate("delete from " + tableNames[cnt]);
            }
        }
        catch (ConnectionNotAvailableException cna) {
            try {
                throw new PersistenceException((Throwable)cna);
                catch (SQLException sqe) {
                    throw new PersistenceException((Throwable)sqe);
                }
            }
            catch (Throwable throwable) {
                DbUtil.closeStatement(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.closeStatement((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    private void purgeCoursesByDataSourceBatchUid(String dataSrcBatchUid, Calendar cal) throws PersistenceException {
        CourseSiteLoader loader = (CourseSiteLoader)this._pm.getLoader("CourseSiteLoader");
        CourseSitePersister persister = (CourseSitePersister)this._pm.getPersister("CourseSitePersister");
        CourseSite crs = new CourseSite();
        crs.setDataSourceBatchUid(dataSrcBatchUid);
        crs.setRowStatus(IAdminObject.RowStatus.DISABLED);
        BbList list = loader.load(crs);
        for (CourseSite course : list) {
            if (course.getModifiedDate() != null && course.getModifiedDate().after(cal)) continue;
            persister.remove(course);
        }
    }
}

