/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.DataSourcePersister;
import blackboard.admin.persist.datasource.impl.mapping.DataSourceDbMap;
import blackboard.data.ValidationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.dao.impl.SimpleDAO;
import blackboard.platform.BbServiceManager;
import blackboard.platform.integration.service.DataSourceManager;
import blackboard.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceManagerImpl
implements DataSourceManager {
    public Id createDataSource(String dataSourceBatchUid, String description) throws ValidationException, PersistenceException {
        if (StringUtil.isEmpty((String)dataSourceBatchUid)) {
            throw new IllegalArgumentException("dataSourceBatchUid can not be null or empty");
        }
        DataSource source = new DataSource();
        source.setBatchUid(dataSourceBatchUid);
        source.setDescription(description);
        DataSourcePersister persister = (DataSourcePersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("DataSourcePersister");
        persister.create(source);
        return source.getDataSourceId();
    }

    public void removeDataSource(Id dataSourceId) {
        SimpleDAO dao = new SimpleDAO(DataSourceDbMap.MAP);
        dao.deleteById(dataSourceId);
    }

    public Map<String, String> getDataSourceData(Id dataSourceId) throws KeyNotFoundException {
        if (null == dataSourceId || !dataSourceId.isSet()) {
            throw new IllegalArgumentException("Data source must not be null and must be set");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDAO dao = new SimpleDAO(DataSourceDbMap.MAP);
        DataSource dataSource = (DataSource)dao.loadById(dataSourceId);
        if (null == dataSource) {
            throw new KeyNotFoundException("Can not find data source by id: " + dataSourceId);
        }
        map = new HashMap();
        map.put("batchUid", dataSource.getBatchUid());
        map.put("description", dataSource.getDescription());
        return map;
    }

    public boolean isExistingDataSource(String dataSourceBatchUid) throws PersistenceException {
        if (StringUtil.isEmpty((String)dataSourceBatchUid)) {
            throw new IllegalArgumentException("dataSourceBatchUid can not be null or empty");
        }
        boolean exists = true;
        DataSourceLoader loader = DataSourceLoader.Default.getInstance();
        try {
            loader.loadByBatchUid(dataSourceBatchUid);
        }
        catch (KeyNotFoundException e) {
            exists = false;
        }
        return exists;
    }

    public Id getDataSourceId(String dataSourceBatchUid) throws KeyNotFoundException, PersistenceException {
        if (StringUtil.isEmpty((String)dataSourceBatchUid)) {
            throw new IllegalArgumentException("dataSourceBatchUid can not be null or empty");
        }
        DataSourceLoader loader = DataSourceLoader.Default.getInstance();
        return loader.loadByBatchUid(dataSourceBatchUid).getId();
    }
}

